/*
 * Decompiled with CFR 0.152.
 */
package com.kirkk.analyzer.textui;

import com.kirkk.analyzer.Analyzer;
import com.kirkk.analyzer.Configuration;
import com.kirkk.analyzer.framework.Jar;
import com.kirkk.analyzer.framework.JarMetrics;
import com.kirkk.analyzer.framework.JarPackage;
import com.kirkk.analyzer.textui.Summary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;

public class XMLUISummary
implements Summary {
    private PrintWriter writer;

    public static void main(String[] stringArray) throws Exception {
        new XMLUISummary().instanceMain(stringArray);
    }

    public void instanceMain(String[] stringArray) throws Exception {
        File file;
        File file2 = stringArray.length > 0 ? new File(stringArray[0]) : null;
        File file3 = file = stringArray.length > 1 ? new File(stringArray[1]) : null;
        if (file2 == null) {
            System.out.print("Please enter input directory name: ");
            file2 = this.getFile();
        }
        if (file == null) {
            System.out.print("Please enter output file name: ");
            file = this.getFile();
        }
        this.createSummary(file2, file);
    }

    public void createSummary(File file, File file2) throws Exception {
        Analyzer analyzer = new Analyzer();
        Jar[] jarArray = analyzer.analyze(file);
        this.outputAll(jarArray, file2);
    }

    public void createSummary(File file, File file2, String string, String string2) throws Exception {
        Analyzer analyzer = new Analyzer();
        Configuration.initialize(string, string2);
        Jar[] jarArray = analyzer.analyze(file);
        this.outputAll(jarArray, file2);
    }

    private File getFile() throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = bufferedReader.readLine();
        File file = new File(string);
        return file;
    }

    private void outputAll(Jar[] jarArray, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            this.writer = new PrintWriter(fileWriter);
        }
        catch (IOException iOException) {
            System.out.println("IOException - Redirecting to System.out");
            System.out.println(iOException);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            this.writer = new PrintWriter(outputStreamWriter);
        }
        this.printHeader();
        this.output(jarArray);
        this.printFooter();
        this.writer.flush();
        this.writer.close();
    }

    private void printHeader() {
        this.writer.println("<?xml version=\"1.0\"?>");
        this.writer.println("<JarAnalyzer>");
    }

    private void printFooter() {
        this.writer.println("</JarAnalyzer>");
    }

    private void output(Jar[] jarArray) {
        this.writer.println(this.tab() + "<Jars>");
        this.writer.println();
        for (int i = 0; i < jarArray.length; ++i) {
            String string = jarArray[i].getJarFileName().substring(jarArray[i].getJarFileName().lastIndexOf("\\") + 1, jarArray[i].getJarFileName().length());
            this.writer.println(this.tab(2) + "<Jar name=\"" + string + "\">");
            this.writer.println(this.tab(3) + "<Summary>");
            this.statistics(jarArray[i]);
            this.writer.println();
            this.metrics(jarArray[i].calculateMetrics());
            this.writer.println();
            this.jarPackages(jarArray[i]);
            this.writer.println();
            this.outgoingDependencies(jarArray[i]);
            this.incomingDependencies(jarArray[i]);
            this.cycles(jarArray[i]);
            this.unresolveableDependencies(jarArray[i]);
            this.writer.println(this.tab(3) + "</Summary>");
            this.writer.println();
            this.writer.println(this.tab(2) + "</Jar>");
            this.writer.println();
        }
        this.writer.println(this.tab() + "</Jars>");
    }

    private void statistics(Jar jar) {
        this.writer.println(this.tab(4) + "<Statistics>");
        this.writer.println(this.tab(5) + "<ClassCount>" + jar.getClassCount() + "</ClassCount>");
        this.writer.println(this.tab(5) + "<AbstractClassCount>" + jar.getAbstractClassCount() + "</AbstractClassCount>");
        this.writer.println(this.tab(5) + "<PackageCount>" + jar.getPackageCount() + "</PackageCount>");
        this.writer.println(this.tab(4) + "</Statistics>");
    }

    private void metrics(JarMetrics jarMetrics) {
        this.writer.println(this.tab(4) + "<Metrics>");
        this.writer.println(this.tab(5) + "<Abstractness>" + jarMetrics.calculateAbstractness().toString() + "</Abstractness>");
        this.writer.println(this.tab(5) + "<Efferent>" + jarMetrics.calculateEfferentCoupling() + "</Efferent>");
        this.writer.println(this.tab(5) + "<Afferent>" + jarMetrics.calculateAfferentCoupling() + "</Afferent>");
        this.writer.println(this.tab(5) + "<Instability>" + jarMetrics.calculateInstability().toString() + "</Instability>");
        this.writer.println(this.tab(5) + "<Distance>" + jarMetrics.calculateDistance().toString() + "</Distance>");
        this.writer.println(this.tab(4) + "</Metrics>");
    }

    private void cycles(Jar jar) {
        this.writer.println(this.tab(4) + "<Cycles>");
        if (jar.hasCycles()) {
            Iterator iterator = jar.getCyclicJars().iterator();
            while (iterator.hasNext()) {
                Jar jar2 = (Jar)iterator.next();
                String string = jar2.getJarFileName();
                this.writer.println(this.tab(5) + "<Cycle>" + string + "</Cycle>");
            }
        }
        this.writer.println(this.tab(4) + "</Cycles>");
        this.writer.println();
    }

    private void outgoingDependencies(Jar jar) {
        this.writer.println(this.tab(4) + "<OutgoingDependencies>");
        Iterator iterator = jar.getOutgoingDependencies().iterator();
        while (iterator.hasNext()) {
            Jar jar2 = (Jar)iterator.next();
            String string = jar2.getJarFileName();
            this.writer.println(this.tab(5) + "<Jar>" + string + "</Jar>");
        }
        this.writer.println(this.tab(4) + "</OutgoingDependencies>");
        this.writer.println();
    }

    private void incomingDependencies(Jar jar) {
        this.writer.println(this.tab(4) + "<IncomingDependencies>");
        Iterator iterator = jar.getIncomingDependencies().iterator();
        while (iterator.hasNext()) {
            Jar jar2 = (Jar)iterator.next();
            String string = jar2.getJarFileName();
            this.writer.println(this.tab(5) + "<Jar>" + string + "</Jar>");
        }
        this.writer.println(this.tab(4) + "</IncomingDependencies>");
        this.writer.println();
    }

    private void externalDependencies(Jar jar) {
        Iterator iterator = jar.getAllExternallyReferencedPackages().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.writer.println(this.tab(5) + "<Package>" + string + "</Package>");
        }
    }

    private void unresolveableDependencies(Jar jar) {
        this.writer.println(this.tab(4) + "<UnresolvedDependencies>");
        Iterator iterator = jar.getAllUnidentifiableExternallyReferencedPackages().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.writer.println(this.tab(5) + "<Package>" + string + "</Package>");
        }
        this.writer.println(this.tab(4) + "</UnresolvedDependencies>");
    }

    private void jarPackages(Jar jar) {
        this.writer.println(this.tab(4) + "<Packages>");
        Iterator iterator = jar.getAllContainedPackages().iterator();
        while (iterator.hasNext()) {
            JarPackage jarPackage = (JarPackage)iterator.next();
            this.writer.println(this.tab(5) + "<Package>" + jarPackage.getLongName() + "</Package>");
        }
        this.writer.println(this.tab(4) + "</Packages>");
    }

    private String tab() {
        return "    ";
    }

    private String tab(int n) {
        String string = this.tab();
        for (int i = 0; i < n - 1; ++i) {
            string = string + this.tab();
        }
        return string;
    }
}

