/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.signal.ant.taskdefs;

import com.nokia.helium.signal.ant.SignalList;
import com.nokia.helium.signal.ant.types.SignalConfig;
import com.nokia.helium.signal.ant.types.SignalNotifierInput;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class Signal
extends Task {
    private String name;
    private String message;
    private Integer result;
    private Vector<SignalNotifierInput> signalNotifierInputs = new Vector();

    public String getMessage() {
        return this.message;
    }

    public SignalNotifierInput createSignalNotifierInput() {
        SignalNotifierInput input = new SignalNotifierInput();
        this.add(input);
        return input;
    }

    public SignalNotifierInput getSignalNotifierInput() {
        return this.signalNotifierInputs.elementAt(0);
    }

    public void add(SignalNotifierInput input) {
        this.signalNotifierInputs.add(input);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResult(int result) {
        this.result = new Integer(result);
    }

    public void execute() {
        boolean failStatus;
        if (this.name == null) {
            throw new BuildException("'name' attribute is not defined.");
        }
        if (this.result == null) {
            this.result = new Integer(0);
        }
        SignalList signalList = new SignalList(this.getProject());
        boolean bl = failStatus = this.result != 0;
        if (failStatus) {
            this.log(this.name + ": " + this.name + " signal failed. Expected result was 0, actual result was " + this.result);
            if (this.message == null) {
                this.message = "Expected result was 0, actual result was " + this.result;
            }
        }
        String targetName = "signalExceptionTarget";
        Target target = this.getOwningTarget();
        if (target != null) {
            targetName = target.getName();
        }
        if (this.signalNotifierInputs.isEmpty()) {
            this.log("Configuring a signal based on signalConfig is now deprecated. Please consider using nested signalInput.", 1);
            Object config = this.getProject().getReference(this.name);
            if (config == null || !(config instanceof SignalConfig)) {
                throw new BuildException("Could not find signal config for signal name: " + this.name);
            }
            signalList.sendSignal(this.getName(), this.result != 0);
            if (this.result != 0) {
                this.log(this.name + ": " + this.name + " signal failed. Expected result was 0, actual result was " + this.result);
                if (this.message == null) {
                    this.message = "Expected result was 0, actual result was " + this.result;
                }
                signalList.fail(this.getName(), this.getOwningTarget().getName(), this.message);
            }
        } else {
            signalList.processForSignal(this.getProject(), this.getSignalNotifierInput(), this.getName(), targetName, this.message, failStatus);
        }
    }
}

