/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.types;

import commonj.sdo.Type;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.metadata.TypeStringConverter;

public class SDOPropertyType
extends SDOType
implements Type {
    private static final String SDO_DO_URL = "org.eclipse.persistence.sdo.dataobjects";
    private boolean initialized = false;
    private SDOTypeHelper typeHelper;

    public SDOPropertyType(SDOTypeHelper sdoTypeHelper, SDOType typeType) {
        super("commonj.sdo", "Property", sdoTypeHelper);
        this.typeHelper = sdoTypeHelper;
        this.setImplClassName("org.eclipse.persistence.sdo.dataobjects.PropertyImpl");
        Class implClass = this.getImplClass();
        this.xmlDescriptor.setJavaClass(implClass);
        this.xmlDescriptor.setInstantiationPolicy(new SDOType.TypeInstantiationPolicy(this));
        XMLSchemaClassPathReference schemaReference = new XMLSchemaClassPathReference();
        schemaReference.setSchemaContext("/sdo:Property");
        this.xmlDescriptor.setSchemaReference(schemaReference);
        SDOProperty aliasNameProperty = new SDOProperty(this.aHelperContext);
        aliasNameProperty.setName("aliasName");
        aliasNameProperty.setMany(true);
        aliasNameProperty.setType(SDOConstants.SDO_STRING);
        this.addDeclaredProperty(aliasNameProperty);
        SDOProperty propNameProperty = new SDOProperty(this.aHelperContext);
        propNameProperty.setName("name");
        propNameProperty.setType(SDOConstants.SDO_STRING);
        this.addDeclaredProperty(propNameProperty);
        SDOProperty manyProperty = new SDOProperty(this.aHelperContext);
        manyProperty.setName("many");
        manyProperty.setType(SDOConstants.SDO_BOOLEAN);
        this.addDeclaredProperty(manyProperty);
        SDOProperty containmentProperty = new SDOProperty(this.aHelperContext);
        containmentProperty.setName("containment");
        containmentProperty.setType(SDOConstants.SDO_BOOLEAN);
        this.addDeclaredProperty(containmentProperty);
        SDOProperty defaultProperty = new SDOProperty(this.aHelperContext);
        defaultProperty.setName("default");
        defaultProperty.setType(SDOConstants.SDO_OBJECT);
        this.addDeclaredProperty(defaultProperty);
        SDOProperty readOnlyProperty = new SDOProperty(this.aHelperContext);
        readOnlyProperty.setName("readOnly");
        readOnlyProperty.setType(SDOConstants.SDO_BOOLEAN);
        this.addDeclaredProperty(readOnlyProperty);
        SDOProperty typeProperty = new SDOProperty(this.aHelperContext);
        typeProperty.setName("type");
        typeProperty.setType(typeType);
        typeProperty.setContainment(false);
        this.addDeclaredProperty(typeProperty);
        SDOProperty oppositeProperty = new SDOProperty(this.aHelperContext);
        oppositeProperty.setName("opposite");
        oppositeProperty.setType(this);
        this.addDeclaredProperty(oppositeProperty);
        SDOProperty nullableProperty = new SDOProperty(this.aHelperContext);
        nullableProperty.setName("nullable");
        nullableProperty.setType(SDOConstants.SDO_BOOLEAN);
        this.addDeclaredProperty(nullableProperty);
        this.setOpen(true);
        this.setFinalized(true);
    }

    public List getAliasNames() {
        return Collections.EMPTY_LIST;
    }

    public List getBaseTypes() {
        return Collections.EMPTY_LIST;
    }

    public String getName() {
        return "Property";
    }

    public String getURI() {
        return "commonj.sdo";
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isDataType() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isSequenced() {
        return false;
    }

    public void initializeMappings() {
        for (SDOProperty nextProp : this.getDeclaredProperties()) {
            if (nextProp.getName().equals("type")) {
                XMLDirectMapping mapping = new XMLDirectMapping();
                mapping.setAttributeName(nextProp.getName());
                String xpath = nextProp.getQualifiedXPath("commonj.sdo", true);
                mapping.setXPath(xpath);
                mapping.setConverter(new TypeStringConverter(this.typeHelper));
                if (this.getXsdType() != null) {
                    ((XMLField)mapping.getField()).setSchemaType(this.getXsdType());
                }
                nextProp.setXmlMapping(mapping);
                nextProp.addMappingToOwner(true, -1);
                continue;
            }
            if (nextProp.getName().equals("opposite")) continue;
            nextProp.buildMapping("commonj.sdo");
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

