/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractCheck;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class CheckUseOfIfInTargets
extends AbstractCheck {
    @Override
    public void run(Element node) {
        if (node.getName().equals("target")) {
            this.checkUseOfIf(node);
        }
    }

    private void checkUseOfIf(Element node) {
        String target = node.attributeValue("name");
        String targetxpath = "//target[@name='" + target + "']//if";
        List statements2 = node.selectNodes(targetxpath);
        for (Node statement : statements2) {
            List conditiontest = statement.selectNodes("./then/property");
            if (conditiontest == null || conditiontest.size() != 1) continue;
            List conditiontest2 = statement.selectNodes("./else/property");
            if (conditiontest2 != null && conditiontest2.size() == 1) {
                this.log("Target " + target + " poor use of if-else-property statement, use condition task");
                continue;
            }
            if (statement.selectNodes("./else").size() != 0) continue;
            this.log("Target " + target + " poor use of if-then-property statement, use condition task");
        }
        List statements = node.selectNodes("//target[@name='" + target + "']/*");
        if (statements.size() <= 1 && node.selectSingleNode(targetxpath + "/else") == null && (node.selectSingleNode(targetxpath + "/isset") != null || node.selectSingleNode(targetxpath + "/not/isset") != null)) {
            this.log("Target " + target + " poor use of if statement, use <target if|unless=\"prop\"");
        }
    }
}

