/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.Platform;
import com.google.common.collect.UnmodifiableIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableSortedSet<E>
extends ImmutableSet<E>
implements SortedSet<E> {
    private static final Comparator NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedSet<Object> NATURAL_EMPTY_SET = new EmptyImmutableSortedSet<Object>(NATURAL_ORDER);
    final Comparator<? super E> comparator;

    private static <E> ImmutableSortedSet<E> emptySet() {
        return NATURAL_EMPTY_SET;
    }

    private static <E> ImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (comparator == NATURAL_ORDER) {
            return ImmutableSortedSet.emptySet();
        }
        return new EmptyImmutableSortedSet<E>(comparator);
    }

    public static <E> ImmutableSortedSet<E> of() {
        return ImmutableSortedSet.emptySet();
    }

    public static <E extends Comparable> ImmutableSortedSet<E> of(E element) {
        Object[] array = new Object[]{Preconditions.checkNotNull(element)};
        return new RegularImmutableSortedSet(array, NATURAL_ORDER);
    }

    public static <E extends Comparable> ImmutableSortedSet<E> of(E ... elements) {
        return ImmutableSortedSet.ofInternal(Ordering.natural(), elements);
    }

    private static <E> ImmutableSortedSet<E> ofInternal(Comparator<? super E> comparator, E ... elements) {
        Object[] array;
        switch (elements.length) {
            case 0: {
                return ImmutableSortedSet.emptySet(comparator);
            }
        }
        for (E e : array = Platform.clone(elements)) {
            Preconditions.checkNotNull(e);
        }
        ImmutableSortedSet.sort(array, comparator);
        array = ImmutableSortedSet.removeDupes(array, comparator);
        return new RegularImmutableSortedSet<E>(array, comparator);
    }

    private static <E> void sort(Object[] array, Comparator<? super E> comparator) {
        Arrays.sort(array, comparator);
    }

    private static <E> Object[] removeDupes(Object[] array, Comparator<? super E> comparator) {
        int size = 1;
        for (int i = 1; i < array.length; ++i) {
            Object element = array[i];
            if (ImmutableSortedSet.compare(comparator, array[size - 1], element) == 0) continue;
            array[size] = element;
            ++size;
        }
        if (size == array.length) {
            return array;
        }
        Object[] copy = new Object[size];
        System.arraycopy(array, 0, copy, 0, size);
        return copy;
    }

    public static <E extends Comparable> ImmutableSortedSet<E> copyOf(Iterable<? extends E> elements) {
        return ImmutableSortedSet.copyOfInternal(Ordering.natural(), elements, false);
    }

    public static <E extends Comparable> ImmutableSortedSet<E> copyOf(Iterator<? extends E> elements) {
        return ImmutableSortedSet.copyOfInternal(Ordering.natural(), elements);
    }

    public static <E> ImmutableSortedSet<E> copyOfSorted(SortedSet<E> sortedSet) {
        Comparator comparator = sortedSet.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        return ImmutableSortedSet.copyOfInternal(comparator, sortedSet, true);
    }

    private static <E> ImmutableSortedSet<E> copyOfInternal(Comparator<? super E> comparator, Iterable<? extends E> elements, boolean fromSortedSet) {
        ImmutableSortedSet result;
        boolean hasSameComparator;
        boolean bl = hasSameComparator = fromSortedSet || ImmutableSortedSet.hasSameComparator(elements, comparator);
        if (hasSameComparator && elements instanceof ImmutableSortedSet && !(result = (ImmutableSortedSet)elements).hasPartialArray()) {
            return result;
        }
        Object[] array = Iterables.newArray(elements, Object.class);
        if (array.length == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        for (Object e : array) {
            Preconditions.checkNotNull(e);
        }
        if (!hasSameComparator) {
            ImmutableSortedSet.sort(array, comparator);
            array = ImmutableSortedSet.removeDupes(array, comparator);
        }
        return new RegularImmutableSortedSet<E>(array, comparator);
    }

    private static <E> ImmutableSortedSet<E> copyOfInternal(Comparator<? super E> comparator, Iterator<? extends E> elements) {
        if (!elements.hasNext()) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ArrayList<E> list = Lists.newArrayList();
        while (elements.hasNext()) {
            list.add(Preconditions.checkNotNull(elements.next()));
        }
        Object[] array = list.toArray();
        ImmutableSortedSet.sort(array, comparator);
        array = ImmutableSortedSet.removeDupes(array, comparator);
        return new RegularImmutableSortedSet<E>(array, comparator);
    }

    private static boolean hasSameComparator(Iterable<?> elements, Comparator<?> comparator) {
        if (elements instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)elements;
            Comparator comparator2 = sortedSet.comparator();
            return comparator2 == null ? comparator == Ordering.natural() : ((Object)comparator).equals(comparator2);
        }
        return false;
    }

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    public static <E extends Comparable> Builder<E> reverseOrder() {
        return new Builder(Collections.reverseOrder());
    }

    public static <E extends Comparable> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    @Deprecated
    public static <E> Builder<E> builder() {
        throw new UnsupportedOperationException();
    }

    private static <E> int compare(Comparator<? super E> comparator, Object a, Object b) {
        return comparator.compare(a, b);
    }

    private ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public ImmutableSortedSet<E> headSet(E toElement) {
        return this.headSetImpl(Preconditions.checkNotNull(toElement));
    }

    @Override
    public ImmutableSortedSet<E> subSet(E fromElement, E toElement) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(ImmutableSortedSet.compare(this.comparator, fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, toElement);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement) {
        return this.tailSetImpl(Preconditions.checkNotNull(fromElement));
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, E var2);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1);

    abstract boolean hasPartialArray();

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm<E>(this.comparator, this.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializedForm<E>
    implements Serializable {
        final Comparator<? super E> comparator;
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        public SerializedForm(Comparator<? super E> comparator, Object[] elements) {
            this.comparator = comparator;
            this.elements = elements;
        }

        Object readResolve() {
            return ((Builder)new Builder<E>(this.comparator).add(this.elements)).build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegularImmutableSortedSet<E>
    extends ImmutableSortedSet<E> {
        final Object[] elements;
        final int fromIndex;
        final int toIndex;

        RegularImmutableSortedSet(Object[] elements, Comparator<? super E> comparator) {
            super(comparator);
            this.elements = elements;
            this.fromIndex = 0;
            this.toIndex = elements.length;
        }

        RegularImmutableSortedSet(Object[] elements, Comparator<? super E> comparator, int fromIndex, int toIndex) {
            super(comparator);
            this.elements = elements;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return Iterators.forArray(this.elements, this.fromIndex, this.size());
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.toIndex - this.fromIndex;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            try {
                return this.binarySearch(o) >= 0;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            if (!ImmutableSortedSet.hasSameComparator(targets, this.comparator()) || targets.size() <= 1) {
                return super.containsAll(targets);
            }
            int i = this.fromIndex;
            Iterator<?> iterator = targets.iterator();
            Object target = iterator.next();
            while (true) {
                if (i >= this.toIndex) {
                    return false;
                }
                int cmp = ImmutableSortedSet.compare(this.comparator, this.elements[i], target);
                if (cmp < 0) {
                    ++i;
                    continue;
                }
                if (cmp == 0) {
                    if (!iterator.hasNext()) {
                        return true;
                    }
                    target = iterator.next();
                    ++i;
                    continue;
                }
                if (cmp > 0) break;
            }
            return false;
        }

        int binarySearch(Object key) {
            int lower = this.fromIndex;
            int upper = this.toIndex - 1;
            while (lower <= upper) {
                int middle = lower + (upper - lower) / 2;
                int c = ImmutableSortedSet.compare(this.comparator, key, this.elements[middle]);
                if (c < 0) {
                    upper = middle - 1;
                    continue;
                }
                if (c > 0) {
                    lower = middle + 1;
                    continue;
                }
                return middle;
            }
            return -lower - 1;
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            System.arraycopy(this.elements, this.fromIndex, array, 0, this.size());
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.size();
            if (array.length < size) {
                array = ObjectArrays.newArray(array, size);
            } else if (array.length > size) {
                array[size] = null;
            }
            System.arraycopy(this.elements, this.fromIndex, array, 0, size);
            return array;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Set)) {
                return false;
            }
            Set that = (Set)object;
            if (this.size() != that.size()) {
                return false;
            }
            if (ImmutableSortedSet.hasSameComparator(that, this.comparator)) {
                Iterator iterator = that.iterator();
                try {
                    for (int i = this.fromIndex; i < this.toIndex; ++i) {
                        Object otherElement = iterator.next();
                        if (otherElement != null && ImmutableSortedSet.compare(this.comparator, this.elements[i], otherElement) == 0) continue;
                        return false;
                    }
                    return true;
                }
                catch (ClassCastException e) {
                    return false;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
            return this.containsAll(that);
        }

        @Override
        public int hashCode() {
            int hash = 0;
            for (int i = this.fromIndex; i < this.toIndex; ++i) {
                hash += this.elements[i].hashCode();
            }
            return hash;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(this.size() * 16);
            result.append('[').append(this.elements[this.fromIndex]);
            for (int i = this.fromIndex + 1; i < this.toIndex; ++i) {
                result.append(", ").append(this.elements[i]);
            }
            return result.append(']').toString();
        }

        @Override
        public E first() {
            return (E)this.elements[this.fromIndex];
        }

        @Override
        public E last() {
            return (E)this.elements[this.toIndex - 1];
        }

        @Override
        ImmutableSortedSet<E> headSetImpl(E toElement) {
            return this.createSubset(this.fromIndex, this.findSubsetIndex(toElement));
        }

        @Override
        ImmutableSortedSet<E> subSetImpl(E fromElement, E toElement) {
            return this.createSubset(this.findSubsetIndex(fromElement), this.findSubsetIndex(toElement));
        }

        @Override
        ImmutableSortedSet<E> tailSetImpl(E fromElement) {
            return this.createSubset(this.findSubsetIndex(fromElement), this.toIndex);
        }

        int findSubsetIndex(E fromElement) {
            int index = this.binarySearch(fromElement);
            return index >= 0 ? index : -index - 1;
        }

        ImmutableSortedSet<E> createSubset(int newFromIndex, int newToIndex) {
            if (newFromIndex < newToIndex) {
                return new RegularImmutableSortedSet<E>(this.elements, this.comparator, newFromIndex, newToIndex);
            }
            return ImmutableSortedSet.emptySet(this.comparator);
        }

        @Override
        boolean hasPartialArray() {
            return this.fromIndex != 0 || this.toIndex != this.elements.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyImmutableSortedSet<E>
    extends ImmutableSortedSet<E> {
        private static final Object[] EMPTY_ARRAY = new Object[0];

        EmptyImmutableSortedSet(Comparator<? super E> comparator) {
            super(comparator);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object target) {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            return targets.isEmpty();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Set) {
                Set that = (Set)object;
                return that.isEmpty();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public E first() {
            throw new NoSuchElementException();
        }

        @Override
        public E last() {
            throw new NoSuchElementException();
        }

        @Override
        ImmutableSortedSet<E> headSetImpl(E toElement) {
            return this;
        }

        @Override
        ImmutableSortedSet<E> subSetImpl(E fromElement, E toElement) {
            return this;
        }

        @Override
        ImmutableSortedSet<E> tailSetImpl(E fromElement) {
            return this;
        }

        @Override
        boolean hasPartialArray() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;

        public Builder(Comparator<? super E> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public Builder<E> add(E element) {
            super.add(element);
            return this;
        }

        @Override
        public Builder<E> add(E ... elements) {
            super.add(elements);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> elements) {
            super.addAll(elements);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> elements) {
            super.addAll(elements);
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            return ImmutableSortedSet.copyOfInternal(this.comparator, this.contents.iterator());
        }
    }
}

