/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.ant.IvyCacheTask;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class IvyCacheFileset
extends IvyCacheTask {
    private String setid;

    public String getSetid() {
        return this.setid;
    }

    public void setSetid(String id) {
        this.setid = id;
    }

    public void setUseOrigin(boolean useOrigin) {
        if (useOrigin) {
            throw new UnsupportedOperationException("the cachefileset task does not support the useOrigin mode, since filesets require to have only one root directory. Please use the the cachepath task instead");
        }
    }

    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.setid == null) {
            throw new BuildException("setid is required in ivy cachefileset");
        }
        try {
            ArtifactDownloadReport a;
            FileSet fileset = new FileSet();
            fileset.setProject(this.getProject());
            this.getProject().addReference(this.setid, (Object)fileset);
            List paths = this.getArtifactReports();
            File base = null;
            Iterator iter = paths.iterator();
            while (iter.hasNext()) {
                a = (ArtifactDownloadReport)iter.next();
                if (a.getLocalFile() == null) continue;
                base = this.getBaseDir(base, a.getLocalFile());
            }
            if (base == null) {
                fileset.setDir(new File("."));
                PatternSet.NameEntry ne = fileset.createExclude();
                ne.setName("**/*");
            } else {
                fileset.setDir(base);
                iter = paths.iterator();
                while (iter.hasNext()) {
                    a = (ArtifactDownloadReport)iter.next();
                    if (a.getLocalFile() == null) continue;
                    PatternSet.NameEntry ne = fileset.createInclude();
                    ne.setName(this.getPath(base, a.getLocalFile()));
                }
            }
        }
        catch (Exception ex) {
            throw new BuildException("impossible to build ivy cache fileset: " + ex, (Throwable)ex);
        }
    }

    private String getPath(File base, File file) {
        return file.getAbsolutePath().substring(base.getAbsolutePath().length() + 1);
    }

    private File getBaseDir(File base, File file) {
        if (base == null) {
            return file.getParentFile();
        }
        String basePath = base.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        for (int i = 0; i < basePath.length(); ++i) {
            if (i >= filePath.length()) {
                return file.getParentFile();
            }
            if (basePath.charAt(i) == filePath.charAt(i)) continue;
            return new File(basePath.substring(0, i));
        }
        return base;
    }
}

