/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.listener.internaldata;

import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public abstract class DataNode {
    private static long commonJobId;
    private long jobId = commonJobId++;
    private DataNode parent;
    private Vector<DataNode> children = new Vector();
    private Date startTime;
    private Date endTime;
    private long threadId = Thread.currentThread().getId();
    private Object reference;

    public DataNode(DataNode parent, Object reference) {
        this.parent = parent;
        if (parent != null) {
            parent.add(this);
        }
        this.setStartTime(new Date());
        this.setReference(reference);
    }

    public void add(DataNode child) {
        this.children.add(child);
    }

    public Iterator<DataNode> iterator() {
        return this.children.iterator();
    }

    public void remove(DataNode child) {
        this.children.remove(child);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public DataNode getParent() {
        return this.parent;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        if (this.endTime != null) {
            return this.endTime;
        }
        return this.getStartTime();
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }

    public long getJobId() {
        return this.jobId;
    }

    public DataNode find(Object reference) {
        if (this.reference == reference) {
            return this;
        }
        for (DataNode node : this.children) {
            DataNode result = node.find(reference);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public abstract String getName();

    public String toString() {
        return this.getName();
    }
}

