/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CommentToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XmlSerializer;

public class CompactXmlSerializer
extends XmlSerializer {
    protected CompactXmlSerializer(Writer writer, HtmlCleaner htmlCleaner) {
        super(writer, htmlCleaner);
    }

    private void serialize(List nodes, TagNode tagNode) throws IOException {
        if (nodes != null && !nodes.isEmpty()) {
            for (Object item : nodes) {
                if (item == null) continue;
                if (item instanceof List) {
                    this.serialize((List)item, tagNode);
                    continue;
                }
                if (item instanceof ContentToken) {
                    ContentToken contentToken = (ContentToken)item;
                    String content = contentToken.getContent().trim();
                    content = !this.dontEscape(tagNode) ? this.escapeXml(content) : content.replaceAll("]]>", "]]&amp;");
                    if (content.length() == 0) continue;
                    this.writer.write(String.valueOf(content) + "\n");
                    continue;
                }
                if (item instanceof CommentToken) {
                    String content = ((CommentToken)item).getContent().toString().trim();
                    this.writer.write(content);
                    continue;
                }
                ((BaseToken)item).serialize(this);
            }
        }
    }

    protected void serialize(TagNode tagNode) throws IOException {
        this.serializeOpenTag(tagNode, false);
        List tagChildren = tagNode.getChildren();
        if (!tagChildren.isEmpty()) {
            this.serialize(tagChildren, tagNode);
            this.serializeEndTag(tagNode, false);
        }
    }
}

