/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.AntTable;
import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.ActionListenerComponent;
import com.sardak.antform.types.DefaultProperty;
import com.sardak.antform.util.CSVReader;
import com.sardak.antform.util.StringUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import org.apache.tools.ant.Task;

public class Table
extends DefaultProperty
implements ActionListenerComponent {
    private String columns;
    private String rowSeparator = ",";
    private String columnSeparator = ";";
    private String escapeSequence = "\\";
    private String[] cols;
    private int width = -1;
    private int height = -1;
    private int columnWidth = -1;
    private boolean bestFitColumns = false;
    private AntTable table;
    private boolean setDataCalled = false;

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public String getEscapeSequence() {
        return this.escapeSequence;
    }

    public void setEscapeSequence(String escapeSequence) {
        this.escapeSequence = escapeSequence;
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public void setRowSeparator(String rowSeparator) {
        this.rowSeparator = rowSeparator;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public void setData(String data) {
        this.setDataCalled = true;
    }

    public String[][] splitData() {
        CSVReader rowReader = new CSVReader(this.rowSeparator, this.escapeSequence);
        CSVReader columnReader = new CSVReader(this.columnSeparator, this.escapeSequence);
        String data = this.getProject().getProperty(this.getProperty());
        if (data == null) {
            data = "";
        }
        List rowsList = rowReader.digest(data, false);
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        int maxCols = this.cols.length;
        Iterator iter = rowsList.iterator();
        while (iter.hasNext()) {
            String row = (String)iter.next();
            if (row.trim().length() == 0) continue;
            List cells = columnReader.digest(row, true);
            String[] cellStrings = cells.toArray(new String[cells.size()]);
            dataList.add(cellStrings);
            if (cellStrings.length <= maxCols) continue;
            maxCols = cellStrings.length;
        }
        String[][] array = new String[dataList.size()][maxCols];
        for (int i = 0; i < dataList.size(); ++i) {
            String[] row = (String[])dataList.get(i);
            array[i] = row;
        }
        return array;
    }

    public String[] splitColumns() {
        CSVReader columnReader = new CSVReader(this.columnSeparator, this.escapeSequence);
        List values = columnReader.digest(this.columns, true);
        this.cols = values.toArray(new String[values.size()]);
        return this.cols;
    }

    public static void main(String[] args) {
        Table t = new Table();
        t.setRowSeparator(";");
        t.setColumnSeparator(",");
        t.setColumns("col1,col2,col3");
        t.setData("d1,d2,d3;d4,d5,d6;d7,d8,d9");
        String[][] array = t.splitData();
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                System.out.println(array[i][j]);
            }
        }
        String[] cols = t.splitColumns();
        for (int i = 0; i < cols.length; ++i) {
            System.out.println(cols[i]);
        }
    }

    public boolean needBestFitColumns() {
        return this.bestFitColumns;
    }

    public void setBestFitColumns(boolean bestFitColumns) {
        this.bestFitColumns = bestFitColumns;
    }

    public void addToControlPanel(ControlPanel panel) {
        this.splitColumns();
        this.table = new AntTable(this.splitData(), this.cols);
        this.table.setEnabled(this.isEditable());
        if (this.columnWidth != -1) {
            this.table.setAutoResizeMode(0);
            Enumeration<TableColumn> e = this.table.getColumnModel().getColumns();
            while (e.hasMoreElements()) {
                TableColumn tc = e.nextElement();
                tc.setPreferredWidth(this.columnWidth);
            }
        }
        if (this.bestFitColumns) {
            this.table.bestFitColumns();
        }
        JScrollPane scrollPane = new JScrollPane(this.table);
        if (this.width > 0 && this.height > 0) {
            scrollPane.setPreferredSize(new Dimension(this.width, this.height));
            this.table.setAutoResizeMode(0);
        }
        this.initComponent(scrollPane, panel);
    }

    public boolean validate(Task task) {
        boolean isValid = super.validate(task, "Table");
        if (this.getColumns() == null) {
            task.log("Table : attribute \"columns\" missing.");
            isValid = false;
        }
        if (this.setDataCalled) {
            task.log("Table : attribute \"data\" is deprecated. It won't be used.", 1);
        }
        return isValid;
    }

    public void ok() {
        StringBuffer buffer = new StringBuffer();
        int noRows = this.table.getRowCount();
        int noCols = this.table.getColumnCount();
        for (int i = 0; i < noRows; ++i) {
            for (int j = 0; j < noCols; ++j) {
                String value = this.table.getValueAt(i, j) + "";
                value = StringUtil.searchReplace(value, this.escapeSequence, this.escapeSequence + this.escapeSequence);
                value = StringUtil.searchReplace(value, this.rowSeparator, this.escapeSequence + this.rowSeparator);
                value = StringUtil.searchReplace(value, this.columnSeparator, this.escapeSequence + this.columnSeparator);
                buffer.append(value);
                if (j == noCols - 1) continue;
                buffer.append(this.columnSeparator);
            }
            if (i == noRows - 1) continue;
            buffer.append(this.rowSeparator);
        }
        this.getProject().setProperty(this.getProperty(), buffer.toString());
    }

    public void reset() {
        String[][] cell = this.splitData();
        for (int row = 0; row < cell.length; ++row) {
            for (int col = 0; col < cell[row].length; ++col) {
                this.table.getModel().setValueAt(cell[row][col], row, col);
            }
        }
    }

    public JComponent getFocusableComponent() {
        return this.table;
    }
}

