/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.types.BaseType;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.tools.ant.Task;

public class Html
extends BaseType
implements HyperlinkListener {
    private int width = 600;
    private int height = 400;
    private String data = null;
    private String urlString = null;
    private File file = null;
    private JEditorPane htmlPane;

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getUrlString() {
        return this.urlString;
    }

    public void setUrlString(String urlString) {
        this.urlString = urlString;
    }

    public void addToControlPanel(ControlPanel panel) {
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.setPreferredSize(new Dimension(this.width, this.height));
        this.htmlPane.addHyperlinkListener(this);
        try {
            if (this.urlString != null) {
                this.htmlPane.setPage(this.urlString);
            } else if (this.file != null) {
                this.htmlPane.setPage(this.file.toURL());
            } else if (this.data != null) {
                this.htmlPane.setText(this.data);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        JScrollPane scrollPane = new JScrollPane(this.htmlPane);
        scrollPane.setPreferredSize(new Dimension(this.width, this.height));
        JLabel labelComponent = panel.makeLabel("");
        labelComponent.setLabelFor(scrollPane);
        panel.addRight(scrollPane);
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlPane.setPage(event.getURL());
            }
            catch (IOException ioe) {
                this.warnUser("Can't follow link to " + event.getURL().toExternalForm() + ": " + ioe);
            }
        }
    }

    private void warnUser(String message) {
        JOptionPane.showMessageDialog(this.htmlPane, message, "Error", 0);
    }

    public boolean validate(Task task) {
        return true;
    }
}

