/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.instr;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.Processor;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.instr.InstrProcessorST;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IPathEnumerator;
import java.io.File;

public abstract class InstrProcessor
extends Processor
implements IPathEnumerator.IPathHandler {
    public static final String PROPERTY_EXCLUDE_SYNTHETIC_METHODS = "instr.exclude_synthetic_methods";
    public static final String PROPERTY_EXCLUDE_BRIDGE_METHODS = "instr.exclude_bridge_methods";
    public static final String PROPERTY_DO_SUID_COMPENSATION = "instr.do_suid_compensation";
    public static final String DEFAULT_EXCLUDE_SYNTHETIC_METHODS = "true";
    public static final String DEFAULT_EXCLUDE_BRIDGE_METHODS = "true";
    public static final String DEFAULT_DO_SUID_COMPENSATION = "true";
    protected File[] m_instrPath;
    protected boolean m_dependsMode = true;
    protected boolean m_canonical;
    protected IInclExclFilter m_coverageFilter;
    protected OutMode m_outMode;
    protected File m_outDir;
    protected File m_mdataOutFile;
    protected Boolean m_mdataOutMerge;
    protected int m_classCopies;
    protected int m_classInstrs;
    protected static final String CLASSES = "classes";
    protected static final String LIB = "lib";
    protected static final boolean IN_CLASSES = true;
    protected static final boolean IN_LIB = false;

    public static InstrProcessor create() {
        return new InstrProcessorST();
    }

    public final synchronized void setInstrPath(String[] path, boolean canonical) {
        this.m_instrPath = path == null || path.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(path, canonical);
        this.m_canonical = canonical;
    }

    public final synchronized void setDependsMode(boolean enable) {
        this.m_dependsMode = enable;
    }

    public final synchronized void setInclExclFilter(String[] specs) {
        this.m_coverageFilter = specs == null ? null : IInclExclFilter.Factory.create(specs);
    }

    public final synchronized void setMetaOutFile(String fileName) {
        if (fileName == null) {
            this.m_mdataOutFile = null;
        } else {
            File _file = new File(fileName);
            if (_file.exists() && !_file.isFile()) {
                throw new IllegalArgumentException("not a file: [" + _file.getAbsolutePath() + "]");
            }
            this.m_mdataOutFile = _file;
        }
    }

    public final synchronized void setMetaOutMerge(Boolean merge) {
        this.m_mdataOutMerge = merge;
    }

    public final synchronized void setInstrOutDir(String dir) {
        if (dir == null) {
            this.m_outDir = null;
        } else {
            File _outDir = new File(dir);
            if (_outDir.exists() && !_outDir.isDirectory()) {
                throw new IllegalArgumentException("not a directory: [" + _outDir.getAbsolutePath() + "]");
            }
            this.m_outDir = _outDir;
        }
    }

    public final synchronized void setOutMode(OutMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("null input: mode");
        }
        this.m_outMode = mode;
    }

    protected InstrProcessor() {
    }

    protected void validateState() {
        super.validateState();
        if (this.m_instrPath == null || this.m_instrPath.length == 0) {
            throw new IllegalStateException("instrumentation path not set");
        }
        if (this.m_outMode == null) {
            throw new IllegalStateException("output mode not set");
        }
        if (this.m_outMode != OutMode.OUT_MODE_OVERWRITE) {
            File[] canonicalInstrPath;
            if (this.m_outDir == null) {
                throw new IllegalStateException("output directory not set");
            }
            File canonicalOutDir = Files.canonicalizeFile(this.m_outDir);
            if (this.m_canonical) {
                canonicalInstrPath = this.m_instrPath;
            } else {
                canonicalInstrPath = new File[this.m_instrPath.length];
                for (int ip = 0; ip < canonicalInstrPath.length; ++ip) {
                    canonicalInstrPath[ip] = Files.canonicalizeFile(this.m_instrPath[ip]);
                }
            }
            int instrPathLength = canonicalInstrPath.length;
            for (File dir = canonicalOutDir; dir != null; dir = dir.getParentFile()) {
                for (int ip = 0; ip < instrPathLength; ++ip) {
                    if (!dir.equals(canonicalInstrPath[ip])) continue;
                    throw new IllegalStateException("output directory [" + canonicalOutDir + "] cannot be one of the instrumentation path directories (or a child thereof)");
                }
            }
        }
    }

    protected void reset() {
        this.m_classInstrs = 0;
        this.m_classCopies = 0;
    }

    protected final void createDir(File dir, boolean mkall) throws EMMARuntimeException {
        if (mkall ? !dir.mkdirs() && !dir.exists() : !dir.mkdir() && !dir.exists()) {
            throw new EMMARuntimeException("OUT_MKDIR_FAILURE", new Object[]{dir.getAbsolutePath()});
        }
    }

    protected final File getFullOutDir(File pathDir, boolean isClass) {
        if (this.m_outMode == OutMode.OUT_MODE_OVERWRITE) {
            return pathDir;
        }
        if (this.m_outMode == OutMode.OUT_MODE_COPY) {
            return this.m_outDir;
        }
        if (this.m_outMode == OutMode.OUT_MODE_FULLCOPY) {
            return isClass ? Files.newFile(this.m_outDir, CLASSES) : Files.newFile(this.m_outDir, LIB);
        }
        throw new IllegalStateException("invalid out mode state: " + this.m_outMode);
    }

    protected final File getFullOutFile(File pathDir, File file, boolean isClass) {
        return Files.newFile(this.getFullOutDir(pathDir, isClass), file.getPath());
    }

    public static final class OutMode {
        public static final OutMode OUT_MODE_COPY = new OutMode("copy");
        public static final OutMode OUT_MODE_FULLCOPY = new OutMode("fullcopy");
        public static final OutMode OUT_MODE_OVERWRITE = new OutMode("overwrite");
        private final String m_name;

        public String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.m_name;
        }

        public static OutMode nameToMode(String name) {
            if (OutMode.OUT_MODE_COPY.m_name.equals(name)) {
                return OUT_MODE_COPY;
            }
            if (OutMode.OUT_MODE_FULLCOPY.m_name.equals(name)) {
                return OUT_MODE_FULLCOPY;
            }
            if (OutMode.OUT_MODE_OVERWRITE.m_name.equals(name)) {
                return OUT_MODE_OVERWRITE;
            }
            return null;
        }

        private OutMode(String name) {
            this.m_name = name;
        }
    }
}

