/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.scm.ant.types;

import com.nokia.helium.scm.ant.types.Tag;
import com.nokia.helium.scm.ant.types.TagSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;

public class LatestTag
extends Tag {
    private String pattern;
    private List<TagSet> tagSets = new ArrayList<TagSet>();

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void add(TagSet tagSet) {
        this.tagSets.add(tagSet);
    }

    @Override
    public String getName() {
        if (this.pattern == null) {
            throw new BuildException("'pattern' attribute has not been defined.");
        }
        List<Tag> tags = this.getCleanedList();
        Collections.sort(tags, new TagComparator(this.getPattern()));
        if (tags.isEmpty()) {
            throw new BuildException("No tag found.");
        }
        this.getProject().log("Latest tag: " + tags.get(0).getName());
        return tags.get(0).getName();
    }

    protected List<Tag> getCleanedList() {
        Pattern pVer = this.getPattern();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (Tag tag : this.getTags()) {
            if (!pVer.matcher(tag.getName()).matches()) continue;
            tags.add(tag);
        }
        return tags;
    }

    protected Pattern getPattern() {
        this.getProject().log("pattern: " + this.pattern, 4);
        String qVer = this.pattern.replaceAll("([.\\:_()])", "\\\\$1");
        this.getProject().log("quoted: " + qVer, 4);
        qVer = qVer.replaceAll("\\*", "(\\\\d+)");
        qVer = "^" + qVer + "$";
        this.getProject().log("final: " + qVer, 4);
        return Pattern.compile(qVer);
    }

    protected List<Tag> getTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (TagSet ts : this.tagSets) {
            if (ts.isReference()) {
                ts = (TagSet)((Object)ts.getRefid().getReferencedObject(this.getProject()));
            }
            for (Tag tag : ts.getTags()) {
                tags.add(tag);
            }
        }
        return tags;
    }

    public class TagComparator<T extends Tag>
    implements Comparator<T> {
        private Pattern pVer;

        public TagComparator(Pattern pattern) {
            this.pVer = pattern;
        }

        @Override
        public int compare(T o1, T o2) {
            LatestTag.this.getProject().log("Comparing: " + ((Tag)((Object)o1)).getName() + ">" + ((Tag)((Object)o2)).getName(), 4);
            if (((Tag)((Object)o1)).getName().equals(((Tag)((Object)o2)).getName())) {
                return 0;
            }
            Matcher m1 = this.pVer.matcher(((Tag)((Object)o1)).getName());
            Matcher m2 = this.pVer.matcher(((Tag)((Object)o2)).getName());
            m1.matches();
            m2.matches();
            int max = m1.groupCount() > m2.groupCount() ? m2.groupCount() : m1.groupCount();
            for (int i = 1; i <= max; ++i) {
                int i1 = Integer.decode(m1.group(i));
                int i2 = Integer.decode(m2.group(i));
                LatestTag.this.getProject().log("Comparing index " + i + ": " + i1 + " < " + i2, 4);
                if (i1 == i2) continue;
                return i2 - i1;
            }
            return 0;
        }
    }
}

