/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core.ant.conditions;

import com.nokia.helium.core.ant.types.ConditionType;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLogCondition
extends ConditionType {
    private String severity;
    private String logRegexp;
    private File fileName;

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setFile(File file) {
        this.fileName = file;
    }

    public void setLogMatcher(String regex) {
        this.logRegexp = regex;
    }

    public int getSeverity() {
        MessageHandler handler;
        int messageCount = 0;
        if (this.fileName == null || !this.fileName.exists()) {
            return -1;
        }
        if (this.severity == null) {
            throw new BuildException("'severity' attribute is not defined");
        }
        this.log("Looking for severity '" + this.severity + "' under '" + this.fileName.getAbsolutePath() + "'");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            handler = new MessageHandler();
            saxParser.parse(this.fileName, (DefaultHandler)handler);
            this.log("Found " + handler.getMessageCount() + " " + this.severity + "(s).");
        }
        catch (Exception exc) {
            throw new BuildException((Throwable)exc);
        }
        return messageCount += handler.getMessageCount();
    }

    @Override
    public boolean eval() {
        int severity = this.getSeverity();
        if (severity < 0) {
            return false;
        }
        return severity > 0;
    }

    class MessageHandler
    extends DefaultHandler {
        private int count;

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, name, attributes);
            if (name.equals(XMLLogCondition.this.severity) && this.count == 0) {
                this.count = Integer.valueOf(attributes.getValue("count"));
            }
        }

        public int getMessageCount() {
            return this.count;
        }
    }
}

