/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata;

import com.nokia.helium.metadata.db.MetaDataDb;
import fmpp.Engine;
import fmpp.tdd.DataLoader;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SQLFMPPLoader
implements DataLoader {
    private static final int READ_LIMIT = 5000;
    private static Logger log = Logger.getLogger(MetaDataDb.class);
    private MetaDataDb metadataDb;

    public Object load(Engine engine, List args) throws Exception {
        log.debug((Object)("args.size:" + args.size()));
        ListIterator iter = args.listIterator();
        int argsSize = args.size();
        if (argsSize < 1) {
            throw new Exception("input DB path should be provided");
        }
        this.metadataDb = new MetaDataDb((String)args.get(0));
        return new QueryModel();
    }

    private class SQLTemplateModelIterator
    implements TemplateModelIterator {
        private String query;
        private List<Map<String, Object>> rowList;
        private int currentOffsetIndex;
        private int count;
        private boolean finished;

        public SQLTemplateModelIterator(String query) {
            this.query = query;
        }

        public TemplateModel next() {
            SimpleHash simpleHash = null;
            try {
                log.debug((Object)"checking any more element");
                if (this.rowList != null && this.count >= this.rowList.size()) {
                    this.finished = true;
                }
                log.debug((Object)("next:count:" + this.count));
                simpleHash = new SimpleHash(this.rowList.get(this.count));
                ++this.count;
                return simpleHash;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public boolean hasNext() {
            int rowListSize;
            if (!(this.rowList != null && 5000 > this.count || this.finished)) {
                log.debug((Object)"getting records");
                this.rowList = SQLFMPPLoader.this.metadataDb.getRecords(this.query, 5000, this.currentOffsetIndex * 5000);
                this.count = 0;
                log.debug((Object)("rowList.size : " + this.rowList.size()));
                if (this.rowList.size() == 0) {
                    this.finished = true;
                }
                ++this.currentOffsetIndex;
            }
            if ((rowListSize = this.rowList.size()) < 5000 && rowListSize == this.count) {
                this.finished = true;
            }
            return !this.finished;
        }
    }

    private class QueryTemplateModel
    implements TemplateCollectionModel,
    TemplateHashModelEx,
    TemplateSequenceModel {
        private Map<String, List<String>> indexMap;
        private String query;
        private boolean isDataRead;

        public QueryTemplateModel(String query) {
            log.debug((Object)("query in SQLTemplateModel" + query));
            this.query = query;
        }

        public TemplateModel get(String key) {
            this.checkAndReadData();
            log.debug((Object)("QueryModel:" + key));
            List<String> dataList = this.indexMap.get(key);
            log.debug((Object)("datalist size" + dataList.size()));
            if (dataList.size() == 1) {
                return new SimpleScalar(dataList.get(0));
            }
            return new SimpleSequence(dataList);
        }

        private void checkAndReadData() {
            if (!this.isDataRead) {
                log.debug((Object)("isDataRead:" + this.isDataRead));
                this.isDataRead = true;
                this.indexMap = SQLFMPPLoader.this.metadataDb.getIndexMap(this.query);
            }
            log.debug((Object)("indexmap size" + this.indexMap.size()));
        }

        public TemplateCollectionModel keys() {
            this.checkAndReadData();
            return new SimpleCollection(this.indexMap.keySet());
        }

        public int size() {
            this.checkAndReadData();
            return this.indexMap.size();
        }

        public TemplateModel get(int index) {
            List<Map<String, Object>> rowList = SQLFMPPLoader.this.metadataDb.getRecords(this.query);
            return new SimpleHash(rowList.get(index));
        }

        public boolean isEmpty() {
            this.checkAndReadData();
            return this.indexMap == null;
        }

        public TemplateCollectionModel values() {
            this.checkAndReadData();
            return new SimpleCollection(this.indexMap.values());
        }

        public TemplateModelIterator iterator() {
            log.debug((Object)"iterator constructor called");
            return new SQLTemplateModelIterator(this.query);
        }
    }

    private class QueryModel
    implements TemplateHashModel {
        private QueryModel() {
        }

        public TemplateModel get(String query) {
            log.debug((Object)("QueryModel:" + query));
            return new QueryTemplateModel(query);
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

