/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.maven.scm.provider.hg;

import com.nokia.maven.scm.command.info.InfoScmResult;
import com.nokia.maven.scm.command.pull.PullScmResult;
import com.nokia.maven.scm.command.tags.TagsScmResult;
import com.nokia.maven.scm.provider.ScmProviderExt;
import com.nokia.maven.scm.provider.hg.command.branch.HgBranchCommand;
import com.nokia.maven.scm.provider.hg.command.checkout.HgCheckOutCommand;
import com.nokia.maven.scm.provider.hg.command.export.HgExportCommand;
import com.nokia.maven.scm.provider.hg.command.info.HgInfoCommand;
import com.nokia.maven.scm.provider.hg.command.init.HgInitCommand;
import com.nokia.maven.scm.provider.hg.command.log.HgChangeLogCommand;
import com.nokia.maven.scm.provider.hg.command.pull.HgPullCommand;
import com.nokia.maven.scm.provider.hg.command.remove.HgRemoveCommand;
import com.nokia.maven.scm.provider.hg.command.tag.HgTagCommand;
import com.nokia.maven.scm.provider.hg.command.tags.HgTagsCommand;
import com.nokia.maven.scm.provider.hg.command.update.HgUpdateCommand;
import com.nokia.maven.scm.provider.hg.repository.HgScmProviderRepository;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class HgScmProviderExt
extends HgScmProvider
implements ScmProviderExt {
    private static Logger log = Logger.getLogger(HgScmProviderExt.class);

    @Override
    public ScmResult init(ScmRepository repository) throws ScmException {
        log.info((Object)"HgScmProviderExt.init()");
        HgInitCommand command = new HgInitCommand();
        return command.executeInitCommand(repository.getProviderRepository());
    }

    public CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgCheckOutCommand command = new HgCheckOutCommand();
        command.setLogger(this.getLogger());
        return (CheckOutScmResult)command.executeCommand(repository, fileSet, parameters);
    }

    public ChangeLogScmResult changelog(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgChangeLogCommand command = new HgChangeLogCommand();
        command.setLogger(this.getLogger());
        return (ChangeLogScmResult)command.executeCommand(repository, fileSet, parameters);
    }

    @Override
    public PullScmResult pull(ScmRepository repository, File path) throws ScmException {
        HgPullCommand command = new HgPullCommand();
        command.setLogger(this.getLogger());
        return (PullScmResult)command.executeCommand(repository.getProviderRepository(), new ScmFileSet(path), new CommandParameters());
    }

    public UpdateScmResult update(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgUpdateCommand command = new HgUpdateCommand();
        command.setLogger(this.getLogger());
        return (UpdateScmResult)command.executeCommand(repository, fileSet, parameters);
    }

    @Override
    public TagsScmResult tags(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgTagsCommand command = new HgTagsCommand();
        command.setLogger(this.getLogger());
        return command.executeCommand(repository.getProviderRepository(), fileSet, parameters);
    }

    @Override
    public InfoScmResult info(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgInfoCommand command = new HgInfoCommand();
        command.setLogger(this.getLogger());
        return command.executeCommand(repository.getProviderRepository(), fileSet, parameters);
    }

    public RemoveScmResult remove(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgRemoveCommand command = new HgRemoveCommand();
        command.setLogger(this.getLogger());
        return (RemoveScmResult)command.execute(repository, fileSet, parameters);
    }

    protected BranchScmResult branch(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgBranchCommand command = new HgBranchCommand();
        command.setLogger(this.getLogger());
        return (BranchScmResult)command.execute(repository, fileSet, parameters);
    }

    protected ExportScmResult export(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgExportCommand command = new HgExportCommand();
        command.setLogger(this.getLogger());
        return (ExportScmResult)command.execute(repository, fileSet, parameters);
    }

    public TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgTagCommand command = new HgTagCommand();
        command.setLogger(this.getLogger());
        return (TagScmResult)command.execute(repository, fileSet, parameters);
    }

    private HgUrlParserResult parseScmUrl(String scmSpecificUrl) {
        HgUrlParserResult result = new HgUrlParserResult();
        URL url = null;
        log.debug((Object)("HgScmProviderExt:parseScmUrl:" + scmSpecificUrl));
        try {
            url = new URL(scmSpecificUrl);
            HgScmProviderRepository repo = new HgScmProviderRepository("file://localhost/");
            repo.configure(url);
            result.repository = (ScmProviderRepository)repo;
        }
        catch (MalformedURLException e) {
            log.debug((Object)("HgScmProviderExt:parseScmUrl:MalformedURLException:" + e.getMessage()));
            try {
                result.setRepository((ScmProviderRepository)new HgScmProviderRepository(scmSpecificUrl));
            }
            catch (Throwable et) {
                log.debug((Object)("HgScmProviderExt:parseScmUrl:Throwable:" + et.getMessage()));
                result.getMessages().add("The filename provided is not valid: " + et.getMessage());
                return result;
            }
        }
        return result;
    }

    public List<String> validateScmUrl(String scmSpecificUrl, char delimiter) {
        HgUrlParserResult result = this.parseScmUrl(scmSpecificUrl);
        return result.messages;
    }

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        HgUrlParserResult result = this.parseScmUrl(scmSpecificUrl);
        if (result.messages.size() > 0) {
            throw new ScmRepositoryException("The scm url is invalid.", result.messages);
        }
        return result.repository;
    }

    private final class HgUrlParserResult {
        private List<String> messages = new ArrayList<String>();
        private ScmProviderRepository repository;

        private HgUrlParserResult() {
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public void setMessages(List<String> messages) {
            this.messages = messages;
        }

        public ScmProviderRepository getRepository() {
            return this.repository;
        }

        public void setRepository(ScmProviderRepository repository) {
            this.repository = repository;
        }
    }
}

