/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:30 $
 * $Revision: 1.22 $
 */

/*
 *		This file was built to correspond with the Visual C++ malloc.h
 */

#ifndef _MSL_MALLOC_H 
#define _MSL_MALLOC_H 

#if (__dest_os == __win32_os)
/* for C++, define inline function rather than macro to expose _msize */
#include <cstdlib>
#include <alloca.h>

#if _MSL_NEEDS_EXTRAS
	#include <extras_malloc.h>
#endif

#ifdef __cplusplus
	inline __std(size_t) _MSL_CDECL _msize(void * ptr) _MSL_CANT_THROW
	{
		return __std(__msize)(ptr);
	}
#else
	#define _msize __msize
#endif

#endif /* __dest_os == __win32_os */

#endif /* _MSL_MALLOC_H */

/* Change record:
 * blc 990209 added _msize macro and inline function, removed prototype for
 *            __alloca, as its always an intrinsic on Intel platforms
 * blc 990216 removed needless namespace definitions, changed alloca to
 *            have prototype for both forms, with macro for non-underscore
 *            form.
 * blc 990217 fixed C compilation error due to illegal 'extern "C"' keywords
 * blc 990331 fix IL9903-2601 -- left off __std() macro around call to __msize
 * cc  000316 added _MSL_IMP_EXP_C
 * hh  010126 wrapped in #if __dest_os == __win32_os
 * cc  010409 moved alloca to alloca.h
 * JWW 010618 Use cname headers exclusively to prevent namespace pollution in C++
 * hh  020603 Added no throw spec to functions
 */