/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.TextLogMetaDataInput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

public class AntLogMetaDataInput
extends TextLogMetaDataInput {
    private Logger log = Logger.getLogger(AntLogMetaDataInput.class);
    private Pattern antTargetPattern = Pattern.compile("^([^\\s=\\[\\]]+):$");
    private String currentComponent;
    private boolean entryCreated;

    @Override
    public boolean isEntryAvailable() {
        String exceptions = "";
        int currentFileIndex = this.getCurrentFileIndex();
        int lineNumber = this.getLineNumber();
        BufferedReader currentReader = this.getCurrentReader();
        this.log.debug((Object)"Getting next set of log entries for Ant Input");
        List<File> fileList = this.getFileList();
        int fileListSize = fileList.size();
        this.log.debug((Object)("fileList.size" + fileListSize));
        while (currentFileIndex < fileListSize) {
            try {
                this.setLineNumber(++lineNumber);
                this.log.debug((Object)("currentfileindex while getting file name: " + currentFileIndex));
                File currentFile = fileList.get(currentFileIndex);
                if (currentReader == null) {
                    this.setLineNumber(0);
                    this.log.debug((Object)("Current Text log file name:" + currentFile));
                    this.log.info((Object)("Processing file: " + currentFile));
                    currentReader = new BufferedReader(new FileReader(currentFile));
                    this.setCurrentReader(currentReader);
                }
                String logText = "";
                while ((logText = currentReader.readLine()) != null) {
                    String severity;
                    Matcher match = this.antTargetPattern.matcher(logText);
                    if (match.matches()) {
                        if (this.currentComponent != null && !this.entryCreated) {
                            this.addEntry("DEFAULT", this.currentComponent, currentFile.toString(), 0, "");
                            this.entryCreated = true;
                            return true;
                        }
                        this.entryCreated = false;
                        this.currentComponent = match.group(1);
                    }
                    if ((severity = this.getSeverity(logText = logText.replaceFirst("^[ ]*\\[.+?\\][ ]*", ""))) == null) continue;
                    this.entryCreated = true;
                    if (this.currentComponent == null) {
                        this.currentComponent = currentFile.getName();
                    }
                    this.addEntry(severity, this.currentComponent, currentFile.toString(), lineNumber, logText);
                    logText = "";
                    return true;
                }
                currentReader.close();
                currentReader = null;
                this.setCurrentReader(currentReader);
                this.setCurrentFileIndex(++currentFileIndex);
            }
            catch (Exception ex) {
                this.log.debug((Object)"Exception in AntLogMetadata", (Throwable)ex);
                try {
                    currentReader.close();
                }
                catch (IOException iex) {
                    this.log.debug((Object)"Exception in closing reader");
                }
                currentReader = null;
                this.setCurrentReader(null);
                exceptions = exceptions + ex.getMessage() + "\n";
                return false;
            }
        }
        if (!exceptions.equals("")) {
            throw new BuildException(exceptions);
        }
        return false;
    }
}

