/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class MethodMap {
    protected static final Object OBJECT = new Object();
    Map methodByNameMap = new Hashtable();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public void add(Method method) {
        String methodName = method.getName();
        ArrayList<Method> l = (ArrayList<Method>)this.methodByNameMap.get(methodName);
        if (l == null) {
            l = new ArrayList<Method>();
            this.methodByNameMap.put(methodName, l);
        }
        l.add(method);
    }

    public List get(String key) {
        return (List)this.methodByNameMap.get(key);
    }

    public Method find(String methodName, Object[] params) throws AmbiguousException {
        List methodList = (List)this.methodByNameMap.get(methodName);
        if (methodList == null) {
            return null;
        }
        Class[] parameterTypes = null;
        Method method = null;
        int numMethods = methodList.size();
        int bestDistance = -2;
        Method bestMethod = null;
        Twonk bestTwonk = null;
        boolean ambiguous = false;
        int i = 0;
        while (i < numMethods) {
            Twonk twonk;
            method = (Method)methodList.get(i);
            parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == params.length && (twonk = this.calcDistance(params, parameterTypes)) != null) {
                if (bestTwonk == null) {
                    bestTwonk = twonk;
                    bestMethod = method;
                } else {
                    int val = twonk.moreSpecific(bestTwonk);
                    if (val == 0) {
                        ambiguous = true;
                    } else if (val == 1) {
                        ambiguous = false;
                        bestTwonk = twonk;
                        bestMethod = method;
                    }
                }
            }
            ++i;
        }
        if (ambiguous) {
            throw new AmbiguousException();
        }
        return bestMethod;
    }

    private Twonk calcDistance(Object[] set, Class[] base) {
        if (set.length != base.length) {
            return null;
        }
        Twonk twonk = new Twonk(set.length);
        boolean distance = false;
        int i = 0;
        while (i < set.length) {
            Class<?> setclass;
            Object invocationArg = set[i];
            Class methodClass = base[i];
            if (invocationArg == null) {
                invocationArg = OBJECT;
            }
            if (!methodClass.isAssignableFrom(setclass = invocationArg.getClass())) {
                if ((set[i] != null || methodClass.isPrimitive()) && !this.checkPrimitive(methodClass, setclass)) {
                    return null;
                }
            } else {
                Class<?> c = setclass;
                while (c != null) {
                    if (!methodClass.isAssignableFrom(c) || methodClass.equals(c)) break;
                    c = c.getSuperclass();
                    ++twonk.distance;
                    int n = i;
                    twonk.vec[n] = twonk.vec[n] + 1;
                }
            }
            ++i;
        }
        return twonk;
    }

    private boolean checkPrimitive(Class formal, Class arg) {
        if (formal.isPrimitive()) {
            if (formal == Boolean.TYPE && arg == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodMap.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return true;
            }
            if (formal == Character.TYPE && arg == (class$java$lang$Character == null ? (class$java$lang$Character = MethodMap.class$("java.lang.Character")) : class$java$lang$Character)) {
                return true;
            }
            if (formal == Byte.TYPE && arg == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return true;
            }
            if (formal == Short.TYPE && (arg == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || arg == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Integer.TYPE && (arg == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || arg == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || arg == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Long.TYPE && (arg == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || arg == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || arg == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || arg == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Float.TYPE && (arg == (class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float) || arg == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || arg == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || arg == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || arg == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Double.TYPE && (arg == (class$java$lang$Double == null ? (class$java$lang$Double = MethodMap.class$("java.lang.Double")) : class$java$lang$Double) || arg == (class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float) || arg == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || arg == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || arg == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || arg == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Twonk {
        public int distance;
        public int[] vec;

        public Twonk(int size) {
            this.vec = new int[size];
        }

        public int moreSpecific(Twonk other) {
            if (other.vec.length != this.vec.length) {
                return -1;
            }
            boolean low = false;
            boolean high = false;
            int i = 0;
            while (i < this.vec.length) {
                if (this.vec[i] > other.vec[i]) {
                    high = true;
                } else if (this.vec[i] < other.vec[i]) {
                    low = true;
                }
                ++i;
            }
            if (high && low) {
                return 0;
            }
            if (high && !low) {
                return -1;
            }
            if (!high && low) {
                return 1;
            }
            return 1;
        }
    }

    public class AmbiguousException
    extends Exception {
    }
}

