/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Map;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ExclusiveIsolatedClientSession
extends IsolatedClientSession {
    protected boolean shouldAlwaysUseExclusiveConnection;

    public ExclusiveIsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        this(parent, connectionPolicy, null);
    }

    public ExclusiveIsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy, Map properties) {
        super(parent, connectionPolicy, properties);
        this.accessor = null;
        this.shouldAlwaysUseExclusiveConnection = connectionPolicy.isExclusiveAlways();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        Object object;
        block6: {
            if (query.getAccessor() == null) {
                if (this.getAccessor() == null) {
                    this.parent.acquireClientConnection(this);
                }
                query.setAccessor(this.getAccessor());
            }
            try {
                object = query.getAccessor().executeCall(call, translationRow, this);
                Object var6_5 = null;
                if (!call.isFinished()) break block6;
                query.setAccessor(null);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_6 = null;
                    if (call.isFinished()) {
                        query.setAccessor(null);
                    }
                    if (this.isActive() || this.getAccessor() == null) break block7;
                    this.parent.releaseClientSession(this);
                }
                throw throwable;
            }
        }
        if (!this.isActive() && this.getAccessor() != null) {
            this.parent.releaseClientSession(this);
        }
        return object;
    }

    public Accessor getAccessor() {
        return this.writeConnection;
    }

    public void setAccessor(Accessor accessor) {
        this.setWriteConnection(accessor);
    }

    protected void releaseWriteConnection() {
    }

    public void postConnectExternalConnection(Accessor accessor) {
        super.postConnectExternalConnection(accessor);
        if (this.parent.hasEventManager()) {
            this.parent.getEventManager().postAcquireExclusiveConnection(this, accessor);
        }
    }

    public void preDisconnectExternalConnection(Accessor accessor) {
        super.preDisconnectExternalConnection(accessor);
        if (this.parent.hasEventManager()) {
            this.parent.getEventManager().preReleaseExclusiveConnection(this, accessor);
        }
    }

    public boolean isExclusiveConnectionRequired() {
        return this.isActive();
    }

    public boolean isExclusiveIsolatedClientSession() {
        return true;
    }

    protected boolean shouldExecuteLocally(DatabaseQuery query) {
        if (this.shouldAlwaysUseExclusiveConnection) {
            return true;
        }
        return super.shouldExecuteLocally(query);
    }
}

