/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint;

import java.util.ArrayList;

public class AntFile
implements Comparable<AntFile> {
    private String name;
    private int warningCount;
    private int errorCount;
    private ArrayList<String> propertiesVisited = new ArrayList();

    public AntFile(String name) {
        this.name = name;
    }

    public void incrementWarningCount() {
        ++this.warningCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void incrementErrorCount() {
        ++this.errorCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void markPropertyAsVisited(String propertyName) {
        this.propertiesVisited.add(propertyName);
    }

    public boolean isPropertyVisited(String propertyName) {
        return this.propertiesVisited.contains(propertyName);
    }

    public String toString() {
        return this.errorCount + " errors and " + this.warningCount + " warnings " + this.name;
    }

    @Override
    public int compareTo(AntFile otherAntFile) {
        return new Integer(otherAntFile.getWarningCount()).compareTo(new Integer(this.warningCount)) * -1;
    }
}

