/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractCheck;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.dom4j.Element;

public class CheckPythonTasks
extends AbstractCheck {
    @Override
    public void run(Element node) {
        if (node.getName().equals("target")) {
            String target = node.attributeValue("name");
            List pythonList = node.selectNodes("//target[@name='" + target + "']/descendant::*[name()=\"hlm:python\"]");
            int i = 0;
            for (Element pythonElement : pythonList) {
                this.writePythonFile(i + "_" + target, pythonElement.getText());
                ++i;
            }
        }
    }

    private void writePythonFile(String name, String text) {
        try {
            String heliumpath = new File(this.getProject().getProperty("helium.build.dir")).getCanonicalPath();
            new File(heliumpath + File.separator + "python").mkdirs();
            File file = new File(heliumpath + File.separator + "python" + File.separator + "target" + name + ".py");
            PrintWriter output = new PrintWriter(new FileOutputStream(file));
            if (!text.equals("")) {
                output.write("def abc():");
                for (String t : text.split("\n")) {
                    output.write("    " + t + "\n");
                }
            }
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Not able to write python file " + name + ".py");
        }
    }
}

