/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.io.SAXReader;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class AntLintTask
extends Task {
    private ArrayList propertiesVisited = new ArrayList();
    private ArrayList antFileSetList = new ArrayList();
    private ArrayList<AntFile> antFilelist = new ArrayList();
    private String configurationPath;
    private boolean tabCharacterCheck;
    private boolean propertyNameCheck;
    private boolean targetNameCheck;
    private boolean indentationCheck;
    private boolean presetDefMacroDefNameCheck;
    private boolean projectNameCheck;
    private boolean descriptionCheck;
    private boolean fileNameCheck;
    private boolean runTargetCheck;
    private boolean antcallCheck;
    private String propertyNamePattern;
    private String targetNamePattern;
    private String presetDefMacroDefNamePattern;
    private String projectNamePattern;
    private String fileNamePattern;
    private AntFile currentFile;

    public AntLintTask() {
        this.setTaskName("antlint");
    }

    public void addFileset(FileSet set) {
        this.antFileSetList.add(set);
    }

    public void setConfigFile(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    public void checkDuplicateNames(Project project) {
        Hashtable taskdefs = project.getTaskDefinitions();
        HashSet classlist = new HashSet();
        Enumeration taskdefsenum = taskdefs.keys();
        ArrayList<String> macros = new ArrayList<String>();
        while (taskdefsenum.hasMoreElements()) {
            String key = (String)taskdefsenum.nextElement();
            Class value = (Class)taskdefs.get(key);
            macros.add(key);
        }
        this.currentFile = new AntFile("General");
        this.antFilelist.add(this.currentFile);
        for (String x : macros) {
            if (macros.contains(x + "Macro") || macros.contains(x + "macro")) {
                this.log("W: " + x + " and " + x + "Macro" + " found duplicate name");
            }
            this.currentFile.incWarningCount();
        }
    }

    public final void execute() {
        try {
            Project project = this.getProject();
            this.getConfiguration();
            this.checkDuplicateNames(project);
            for (FileSet fs : this.antFileSetList) {
                DirectoryScanner ds = fs.getDirectoryScanner(project);
                String[] srcFiles = ds.getIncludedFiles();
                String basedir = ds.getBasedir().getPath();
                for (int i = 0; i < srcFiles.length; ++i) {
                    String antFileName = basedir + File.separator + srcFiles[i];
                    this.log("*************** Ant File: " + antFileName);
                    this.currentFile = new AntFile(antFileName);
                    this.antFilelist.add(this.currentFile);
                    this.checkFileName(new File(antFileName).getName());
                    SAXReader saxReader = new SAXReader();
                    Document doc = saxReader.read(new File(antFileName));
                    this.treeWalk(doc);
                    SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                    saxFactory.setNamespaceAware(true);
                    saxFactory.setValidating(true);
                    SAXParser parser = saxFactory.newSAXParser();
                    AntLintHandler handler = new AntLintHandler();
                    parser.parse(new File(antFileName), (DefaultHandler)handler);
                }
                Collections.sort(this.antFilelist);
            }
        }
        catch (Exception e) {
            throw new BuildException("Exception occured while running AntLint task " + e.getMessage());
        }
        for (AntFile s : this.antFilelist) {
            this.log(s.toString());
        }
    }

    public final void treeWalk(Document document) {
        Element rootElement = document.getRootElement();
        AntProjectVisitor visitorRootElement = new AntProjectVisitor();
        rootElement.accept((Visitor)visitorRootElement);
        this.treeWalk(rootElement);
    }

    public final void treeWalk(Element element) {
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node node = element.node(i);
            if (!(node instanceof Element)) continue;
            AntXMLVisitor visitorElement = new AntXMLVisitor();
            node.accept((Visitor)visitorElement);
            this.treeWalk((Element)node);
        }
    }

    private void checkFileName(String text) {
        try {
            boolean found = false;
            Pattern p1 = Pattern.compile(this.fileNamePattern);
            Matcher m1 = p1.matcher(text);
            while (m1.find()) {
                found = true;
            }
            if (!found && this.fileNameCheck) {
                this.log("W: INVALID File Name: " + text);
                this.currentFile.incWarningCount();
            }
        }
        catch (Exception e) {
            throw new BuildException("W: INVALID File Name: " + text + e.getMessage());
        }
    }

    public final void getConfiguration() {
        try {
            SAXReader saxConfigReader = new SAXReader();
            Document docConfig = saxConfigReader.read(new File(this.configurationPath));
            Element rootConfig = docConfig.getRootElement();
            Iterator i = rootConfig.elementIterator();
            while (i.hasNext()) {
                Element elementConfig = (Element)i.next();
                String attrName = elementConfig.attributeValue("name");
                if (attrName.equals("TabCharacter")) {
                    this.tabCharacterCheck = true;
                    continue;
                }
                if (attrName.equals("PropertyName")) {
                    this.propertyNameCheck = true;
                    this.propertyNamePattern = elementConfig.getText();
                    continue;
                }
                if (attrName.equals("TargetName")) {
                    this.targetNameCheck = true;
                    this.targetNamePattern = elementConfig.getText();
                    continue;
                }
                if (attrName.equals("Indentation")) {
                    this.indentationCheck = true;
                    continue;
                }
                if (attrName.equals("PresetDefMacroDefName")) {
                    this.presetDefMacroDefNameCheck = true;
                    this.presetDefMacroDefNamePattern = elementConfig.getText();
                    continue;
                }
                if (attrName.equals("ProjectName")) {
                    this.projectNameCheck = true;
                    this.projectNamePattern = elementConfig.getText();
                    continue;
                }
                if (attrName.equals("Description")) {
                    this.descriptionCheck = true;
                    continue;
                }
                if (attrName.equals("FileName")) {
                    this.fileNameCheck = true;
                    this.fileNamePattern = elementConfig.getText();
                    continue;
                }
                if (attrName.equals("RunTarget")) {
                    this.runTargetCheck = true;
                    continue;
                }
                if (!attrName.equals("AntCall")) continue;
                this.antcallCheck = true;
            }
        }
        catch (Exception e) {
            throw new BuildException("Not able to read the ANT lint Configuration file " + this.configurationPath);
        }
    }

    private class AntLintHandler
    extends DefaultHandler {
        private int indentLevel;
        private int indentSpace;
        private Locator locator;
        private boolean textElement;
        private int currentLine;
        private StringBuffer strBuff = new StringBuffer();

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startDocument() {
            this.indentLevel -= 4;
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            this.countSpaces();
            this.indentLevel += 4;
            this.checkIndent();
            this.currentLine = this.locator.getLineNumber();
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            this.countSpaces();
            if (this.currentLine != this.locator.getLineNumber()) {
                this.checkIndent();
            }
            this.indentLevel -= 4;
            this.textElement = false;
        }

        private void checkIndent() {
            if (AntLintTask.this.indentationCheck && this.indentSpace != this.indentLevel && !this.textElement) {
                AntLintTask.this.log("E:" + this.locator.getLineNumber() + ": Bad indentation!");
                AntLintTask.this.currentFile.incErrorCount();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            for (int i = start; i < start + length; ++i) {
                this.strBuff.append(ch[i]);
            }
        }

        public void countSpaces() {
            int numSpaces = 0;
            block6: for (int i = 0; i < this.strBuff.length(); ++i) {
                switch (this.strBuff.charAt(i)) {
                    case '\t': {
                        numSpaces += 4;
                        if (!AntLintTask.this.tabCharacterCheck) continue block6;
                        AntLintTask.this.log("E:" + this.locator.getLineNumber() + ": Tabs should not be used!");
                        AntLintTask.this.currentFile.incErrorCount();
                        continue block6;
                    }
                    case '\n': {
                        numSpaces = 0;
                        continue block6;
                    }
                    case '\r': {
                        continue block6;
                    }
                    case ' ': {
                        ++numSpaces;
                        continue block6;
                    }
                    default: {
                        this.textElement = true;
                    }
                }
            }
            this.indentSpace = numSpaces;
            this.strBuff.delete(0, this.strBuff.length());
        }
    }

    private class AntProjectVisitor
    extends VisitorSupport {
        private AntProjectVisitor() {
        }

        public void visit(Element node) {
            String name = node.getName();
            if (name.equals("project")) {
                String text = node.attributeValue("name");
                if (text != null && AntLintTask.this.projectNameCheck) {
                    this.checkProjectName(text);
                } else {
                    AntLintTask.this.log("W: Project name not specified!");
                    AntLintTask.this.currentFile.incWarningCount();
                }
                if (node.element("description") == null && AntLintTask.this.descriptionCheck) {
                    AntLintTask.this.log("W: Description not specified!");
                    AntLintTask.this.currentFile.incWarningCount();
                }
            }
        }

        private void checkProjectName(String text) {
            try {
                Pattern p1 = Pattern.compile(AntLintTask.this.projectNamePattern);
                Matcher m1 = p1.matcher(text);
                if (!m1.matches()) {
                    AntLintTask.this.log("W: INVALID Project Name: " + text);
                    AntLintTask.this.currentFile.incWarningCount();
                }
            }
            catch (Exception e) {
                throw new BuildException("Not able to match Project Name for " + text);
            }
        }
    }

    private class AntXMLVisitor
    extends VisitorSupport {
        private AntXMLVisitor() {
        }

        public void visit(Element node) {
            String text;
            String name = node.getName();
            if (name.equals("target")) {
                this.checkTarget(node);
            }
            if (name.equals("property") && (text = node.attributeValue("name")) != null && AntLintTask.this.propertyNameCheck) {
                this.checkPropertyName(text);
            }
            if (name.equals("equals") && ((text = node.attributeValue("arg2")).equals("true") || text.equals("yes"))) {
                AntLintTask.this.log("E: " + node.attributeValue("arg1") + " uses 'equals' should use 'istrue' task");
                AntLintTask.this.currentFile.incErrorCount();
            }
            if (name.equals("presetdef") || name.equals("macrodef")) {
                text = node.attributeValue("name");
                if (text != null && AntLintTask.this.presetDefMacroDefNameCheck) {
                    this.checkDefName(text);
                }
                List attributeList = node.elements("attribute");
                for (Element attributeElement : attributeList) {
                    String attributeName = attributeElement.attributeValue("name");
                    this.checkDefName(attributeName);
                }
            }
            if (name.equals("scriptdef")) {
                String scriptdefname = node.attributeValue("name");
                String language = node.attributeValue("language");
                this.checkScriptdef(scriptdefname, (Node)node);
                if (language.equals("beanshell")) {
                    this.writeBeanshellFile(scriptdefname, node.getText());
                }
                if (language.equals("jep") || language.equals("jython")) {
                    this.writeJepFile(scriptdefname, node.getText());
                    this.checkJepPropertiesInText(node.getText());
                }
            }
        }

        private void checkTarget(Element node) {
            String target = node.attributeValue("name");
            if (target != null && AntLintTask.this.targetNameCheck) {
                this.checkTargetName(target);
            } else {
                AntLintTask.this.log("W: Target name not specified!");
                AntLintTask.this.currentFile.incWarningCount();
            }
            this.checkUseOfIf(node);
            this.checkSizeOfScript(node);
            this.checkTabsInScript(node);
            if (node.elements("runtarget") != null && AntLintTask.this.runTargetCheck) {
                List runTargetList = node.elements("runtarget");
                for (Element runTargetElement : runTargetList) {
                    String runTargetName = runTargetElement.attributeValue("target");
                    if (!this.checkTargetDependency(runTargetName)) continue;
                    AntLintTask.this.log("W: <runtarget> calls the target " + runTargetName + " that has dependencies!");
                    AntLintTask.this.currentFile.incWarningCount();
                }
            }
            if (node.elements("antcall") != null && AntLintTask.this.antcallCheck) {
                List antcallList = node.elements("antcall");
                for (Element antcallElement : antcallList) {
                    String antcallName = antcallElement.attributeValue("target");
                    if (node.elements("param") != null || this.checkTargetDependency(antcallName)) continue;
                    AntLintTask.this.log("R: <antcall> is used with no param elements and calls the target " + antcallName + " that has no dependencies! (<runtarget> could be used instead.)");
                    AntLintTask.this.currentFile.incWarningCount();
                }
            }
            List scriptList = node.selectNodes("//target[@name='" + target + "']/descendant::script");
            for (Element scriptElement : scriptList) {
                String language = scriptElement.attributeValue("language");
                if (!language.equals("jep") && !language.equals("jython")) continue;
                this.writeJepFile("target_" + target, scriptElement.getText());
                this.checkJepPropertiesInText(scriptElement.getText());
            }
            List scriptList2 = node.selectNodes("//target[@name='" + target + "']/descendant::scriptcondition");
            for (Element scriptElement2 : scriptList2) {
                String language2 = scriptElement2.attributeValue("language");
                if (!language2.equals("jep") && !language2.equals("jython")) continue;
                this.writeJepFile("scriptcondition_" + target, scriptElement2.getText());
                this.checkJepPropertiesInText(scriptElement2.getText());
            }
            List pythonList = node.selectNodes("//target[@name='" + target + "']/descendant::*[name()=\"hlm:python\"]");
            int i = 0;
            for (Element pythonElement : pythonList) {
                this.writePythonFile(i + "_" + target, pythonElement.getText());
                ++i;
            }
        }

        private void writePythonFile(String scriptdefname, String text) {
            try {
                String heliumpath = new File(AntLintTask.this.project.getProperty("helium.build.dir")).getCanonicalPath();
                new File(heliumpath + File.separator + "python").mkdirs();
                File file = new File(heliumpath + File.separator + "python" + File.separator + "target" + scriptdefname + ".py");
                PrintWriter output = new PrintWriter(new FileOutputStream(file));
                if (!text.equals("")) {
                    output.write("def abc():");
                    for (String t : text.split("\n")) {
                        output.write("    " + t + "\n");
                    }
                }
                output.close();
                this.checkPropertiesInText(text);
            }
            catch (Exception e) {
                throw new BuildException("Not able to write python file " + scriptdefname + ".py");
            }
        }

        private void writeBeanshellFile(String scriptdefname, String text) {
            scriptdefname = "Beanshell" + scriptdefname;
            try {
                String heliumpath = new File(AntLintTask.this.project.getProperty("helium.build.dir")).getCanonicalPath();
                new File(heliumpath + File.separator + "beanshell").mkdirs();
                File file = new File(heliumpath + File.separator + "beanshell" + File.separator + scriptdefname + ".java");
                PrintWriter output = new PrintWriter(new FileOutputStream(file));
                for (String line : text.split("\n")) {
                    if (!line.trim().startsWith("import")) continue;
                    output.write(line + "\n");
                }
                output.write("/**\n * x\n */\npublic final class " + scriptdefname + " {\n");
                output.write("private " + scriptdefname + "() { }\n");
                output.write("public static void main(String[] args) {\n");
                for (String line : text.split("\n")) {
                    if (line.trim().startsWith("import")) continue;
                    output.write(line + "\n");
                }
                output.write("} }");
                output.close();
            }
            catch (Exception e) {
                throw new BuildException("Not able to write Beanshell File " + scriptdefname + ".java");
            }
        }

        private void writeJepFile(String scriptdefname, String text) {
            if (text.contains("${")) {
                AntLintTask.this.log("E: ${ found in " + scriptdefname);
                AntLintTask.this.currentFile.incErrorCount();
            }
            try {
                String heliumpath = new File(AntLintTask.this.project.getProperty("helium.build.dir")).getCanonicalPath();
                new File(heliumpath + File.separator + "jep").mkdirs();
                File file = new File(heliumpath + File.separator + "jep" + File.separator + scriptdefname + "_jep.py");
                PrintWriter output = new PrintWriter(new FileOutputStream(file));
                output.write("def abc():\n");
                output.write("    attributes = {} # pylint: disable-msg=C0103\n");
                output.write("    elements = {} # pylint: disable-msg=C0103\n");
                output.write("    project = None # pylint: disable-msg=C0103\n");
                output.write("    self = None # pylint: disable-msg=C0103\n");
                text = text.replace(" File(", " self.File(");
                for (String t : text.split("\n")) {
                    output.write("    " + t + "\n");
                }
                output.close();
                if (text.contains("import ")) {
                    File file2 = new File(heliumpath + File.separator + "test_jython.xml");
                    PrintWriter output2 = new PrintWriter(new FileOutputStream(file2, true));
                    output2.write("try:\n");
                    for (String line : text.split("\n")) {
                        if (!line.trim().startsWith("import ") && !line.trim().startsWith("from ")) continue;
                        output2.write("    " + line + "\n");
                    }
                    output2.write("except ImportError, e:\n");
                    output2.write("    print '" + scriptdefname + " failed: ' + str(e)\n");
                    output2.close();
                }
            }
            catch (Exception e) {
                throw new BuildException("Not able to write JEP File " + scriptdefname + "_jep.py");
            }
        }

        private void checkJepPropertiesInText(String text) {
            Pattern p1 = Pattern.compile("getProperty\\([\"']([a-zA-Z0-9\\.]*)[\"']\\)");
            Matcher m1 = p1.matcher(text);
            ArrayList<String> props = new ArrayList<String>();
            while (m1.find()) {
                props.add(m1.group(1));
            }
            for (String group : props) {
                this.checkPropertyInModel(group);
            }
        }

        private void checkPropertiesInText(String text) {
            Pattern p1 = Pattern.compile("r[\"']\\$\\{([a-zA-Z0-9\\.]*)\\}[\"']");
            Matcher m1 = p1.matcher(text);
            ArrayList<String> props = new ArrayList<String>();
            while (m1.find()) {
                props.add(m1.group(1));
            }
            for (String group : props) {
                this.checkPropertyInModel(group);
            }
        }

        public void checkScriptdef(String name, Node node) {
            List statements = node.selectNodes("//scriptdef[@name='" + name + "']/attribute");
            Pattern p1 = Pattern.compile("attributes.get\\([\"']([^\"']*)[\"']\\)");
            Matcher m1 = p1.matcher(node.getText());
            ArrayList<String> props = new ArrayList<String>();
            while (m1.find()) {
                props.add(m1.group(1));
            }
            ArrayList<String> attributes = new ArrayList<String>();
            for (Node statement : statements) {
                attributes.add(statement.valueOf("@name"));
            }
            for (String x : props) {
                if (attributes.contains(x)) continue;
                AntLintTask.this.log("E: Scriptdef " + name + " does not have attribute " + x);
                AntLintTask.this.currentFile.incErrorCount();
            }
            if (!statements.isEmpty() && props.isEmpty()) {
                AntLintTask.this.log("W: Scriptdef " + name + " doesn't reference attributes directly, poor style");
                AntLintTask.this.currentFile.incWarningCount();
            } else {
                for (Node statement : statements) {
                    if (props.contains(statement.valueOf("@name"))) continue;
                    AntLintTask.this.log("E: Scriptdef " + name + " does not use " + statement.valueOf("@name"));
                    AntLintTask.this.currentFile.incErrorCount();
                }
            }
        }

        public void checkPropertyInModel(String customerProp) {
            SAXReader xmlReader = new SAXReader();
            Document antDoc = null;
            try {
                File model = new File(AntLintTask.this.project.getProperty("data.model.parsed"));
                antDoc = xmlReader.read(model);
            }
            catch (Exception e) {
                throw new BuildException("Not able to read data model file " + AntLintTask.this.project.getProperty("data.model.parsed"));
            }
            List statements = antDoc.selectNodes("//property");
            for (Node statement : statements) {
                if (!customerProp.equals(statement.valueOf("name"))) continue;
                return;
            }
            AntLintTask.this.log("W: " + customerProp + " not in data model");
            AntLintTask.this.currentFile.incWarningCount();
        }

        private void checkTargetName(String text) {
            try {
                Pattern p1 = Pattern.compile(AntLintTask.this.targetNamePattern);
                Matcher m1 = p1.matcher(text);
                if (!m1.matches()) {
                    AntLintTask.this.log("W: INVALID Target Name: " + text);
                    AntLintTask.this.currentFile.incWarningCount();
                }
            }
            catch (Exception e) {
                throw new BuildException("Not able to match the target name for " + text);
            }
        }

        private void checkUseOfIf(Element node) {
            String target = node.attributeValue("name");
            String targetxpath = "//target[@name='" + target + "']//if";
            List statements2 = node.selectNodes(targetxpath);
            for (Node statement : statements2) {
                List conditiontest = statement.selectNodes("./then/property");
                if (conditiontest == null || conditiontest.size() != 1) continue;
                List conditiontest2 = statement.selectNodes("./else/property");
                if (conditiontest2 != null && conditiontest2.size() == 1) {
                    AntLintTask.this.log("W: Target " + target + " poor use of if-else-property statement, use condition task");
                    AntLintTask.this.currentFile.incWarningCount();
                    continue;
                }
                if (statement.selectNodes("./else").size() != 0) continue;
                AntLintTask.this.log("W: Target " + target + " poor use of if-then-property statement, use condition task");
                AntLintTask.this.currentFile.incWarningCount();
            }
            List statements = node.selectNodes("//target[@name='" + target + "']/*");
            if (statements.size() <= 1 && node.selectSingleNode(targetxpath + "/else") == null && (node.selectSingleNode(targetxpath + "/isset") != null || node.selectSingleNode(targetxpath + "/not/isset") != null)) {
                AntLintTask.this.log("W: Target " + target + " poor use of if statement, use <target if|unless=\"prop\"");
                AntLintTask.this.currentFile.incWarningCount();
            }
        }

        private void checkSizeOfScript(Element node) {
            String target = node.attributeValue("name");
            List statements = node.selectNodes("//target[@name='" + target + "']/script | //target[@name='" + target + "']/*[name()=\"hlm:python\"]");
            for (Node statement : statements) {
                int size = statement.getText().length();
                if (size <= 1000) continue;
                AntLintTask.this.log("W: Target " + target + " has a script with " + size + " characters, code should be inside a python file");
                AntLintTask.this.currentFile.incWarningCount();
            }
        }

        private void checkTabsInScript(Element node) {
            String target = node.attributeValue("name");
            List statements = node.selectNodes("//target[@name='" + target + "']/script | //target[@name='" + target + "']/*[name()=\"hlm:python\"]");
            for (Node statement : statements) {
                if (!statement.getText().contains("\t")) continue;
                AntLintTask.this.log("E: Target " + target + " has a script with tabs");
                AntLintTask.this.currentFile.incErrorCount();
            }
        }

        private void checkPropertyName(String text) {
            try {
                Pattern p1 = Pattern.compile(AntLintTask.this.propertyNamePattern);
                Matcher m1 = p1.matcher(text);
                if (!m1.matches() && !AntLintTask.this.propertiesVisited.contains(text)) {
                    AntLintTask.this.log("W: INVALID Property Name: " + text);
                    AntLintTask.this.propertiesVisited.add(text);
                    AntLintTask.this.currentFile.incWarningCount();
                }
            }
            catch (Exception e) {
                throw new BuildException("Not able to match the Property Name for " + text);
            }
        }

        private void checkDefName(String text) {
            try {
                Pattern p1 = Pattern.compile(AntLintTask.this.presetDefMacroDefNamePattern);
                Matcher m1 = p1.matcher(text);
                if (!m1.matches()) {
                    AntLintTask.this.log("W: INVALID PRESETDEF/MACRODEF Name: " + text);
                    AntLintTask.this.currentFile.incWarningCount();
                }
            }
            catch (Exception e) {
                throw new BuildException("Not able to match the MacroDef Name for " + text);
            }
        }

        private boolean checkTargetDependency(String text) {
            boolean dependencyCheck = false;
            try {
                Target targetDependency = (Target)AntLintTask.this.project.getTargets().get(text);
                if (targetDependency != null) {
                    if (targetDependency.getDependencies().hasMoreElements()) {
                        dependencyCheck = true;
                        return dependencyCheck;
                    }
                }
            }
            catch (Exception e) {
                throw new BuildException("Not able to get Target Dependency for " + text);
            }
            finally {
                return dependencyCheck;
            }
        }
    }

    private class AntFile
    implements Comparable<AntFile> {
        private String name;
        private int warningCount;
        private int errorCount;

        public AntFile(String n) {
            this.name = n;
        }

        public void incWarningCount() {
            ++this.warningCount;
        }

        public int getWarningCount() {
            return this.warningCount;
        }

        public void incErrorCount() {
            ++this.errorCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public String toString() {
            if (this.errorCount > 0) {
                throw new BuildException(this.errorCount + " errors found in " + this.name);
            }
            return this.warningCount + " warnings " + this.name;
        }

        @Override
        public int compareTo(AntFile o) {
            return new Integer(o.getWarningCount()).compareTo(new Integer(this.warningCount)) * -1;
        }
    }
}

