/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.logger.ant.listener;

import com.nokia.helium.logger.ant.listener.BuildStatusReport;
import com.nokia.helium.logger.ant.listener.Handler;
import com.nokia.helium.logger.ant.types.Stage;
import com.nokia.helium.logger.ant.types.StageSummary;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.InvalidReferenceException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.util.DateUtils;

public class StageSummaryHandler
implements Handler {
    public static final String PASSED = "PASSED";
    public static final String FAILED = "FAILED";
    private Logger log = Logger.getLogger(this.getClass());
    private boolean displaySummary;
    private boolean lookup4Stages;
    private boolean summarize;
    private List<BuildStatusReport> statusReports = new ArrayList<BuildStatusReport>();
    private HashSet<String> completedStages = new HashSet();
    private Hashtable<String, Stage> currentStages = new Hashtable();
    private Hashtable<String, Long> currentStagesStartTime = new Hashtable();
    private Hashtable<String, Stage> stages;
    private String template;

    public StageSummaryHandler() {
        this.log.debug((Object)"StageStatusHandler instantiated");
    }

    @Override
    public void handleBuildStarted(BuildEvent event) {
    }

    @Override
    public void handleBuildFinished(BuildEvent event) {
        if (this.summarize && !this.currentStages.isEmpty()) {
            Long currTime = this.getCurrentTime();
            String reason = this.getReason(event.getException());
            Hashtable<String, Stage> tempStages = new Hashtable<String, Stage>(this.currentStages);
            for (String stageName : tempStages.keySet()) {
                this.endCurrentStage(stageName, (Stage)((Object)tempStages.get(stageName)), reason, currTime);
            }
        }
        if (this.summarize && this.displaySummary) {
            this.generateSummary(event.getProject());
            this.displaySummary = false;
            this.log.debug((Object)"Stage Summary generation completed");
        }
    }

    @Override
    public void handleTargetStarted(BuildEvent event) {
        Project project = event.getProject();
        if (!this.summarize) {
            StageSummary stageSummary = this.getStageSummary(project);
            this.lookup4Stages = this.summarize = stageSummary != null && !stageSummary.getTemplate().trim().isEmpty();
            this.template = stageSummary.getTemplate();
            this.log.debug((Object)("Is Project configured to display Stage Summary ? " + this.summarize));
        }
        if (this.lookup4Stages) {
            this.log.debug((Object)"Loading stages....");
            this.parseStages(event.getProject());
            this.log.debug((Object)("Total no of stages loaded = " + this.stages.size()));
            this.lookup4Stages = false;
        }
        this.log.debug((Object)("Handling target - " + event.getTarget().getName()));
        if (this.summarize) {
            Long currTime = this.getCurrentTime();
            TreeMap<String, Stage> result = this.searchNewStage(event);
            if (result != null && result.size() == 1) {
                String stageName = result.firstKey();
                Stage stage = result.get(stageName);
                this.startNewStage(stageName, stage, currTime);
            }
        }
    }

    @Override
    public void handleTargetFinished(BuildEvent event) {
        TreeMap<String, Stage> result;
        String currentTarget = event.getTarget().getName();
        Long currTime = this.getCurrentTime();
        String reason = this.getReason(event.getException());
        if (this.summarize && !this.currentStages.isEmpty() && !(result = this.getCurrentStageToEnd(currentTarget)).isEmpty()) {
            String stageName = result.firstKey();
            Stage stage = result.get(stageName);
            this.endCurrentStage(stageName, stage, reason, currTime);
        }
    }

    private TreeMap<String, Stage> getCurrentStageToEnd(String target) {
        TreeMap<String, Stage> result = new TreeMap<String, Stage>();
        for (String stageName : this.currentStages.keySet()) {
            Stage stage = this.currentStages.get(stageName);
            if (!stage.isEndTarget(target)) continue;
            result.put(stageName, stage);
            break;
        }
        return result;
    }

    private StageSummary getStageSummary(Project project) {
        StageSummary stageSummary = null;
        int count = 0;
        Hashtable references = project.getReferences();
        Enumeration en = references.keys();
        while (en.hasMoreElements()) {
            Object object = references.get(en.nextElement());
            if (!(object instanceof StageSummary)) continue;
            if (++count > 1) {
                this.raiseException("Multiple entries of 'hlm:stagesummary' found in stages_config.ant.xml.");
            }
            stageSummary = (StageSummary)((Object)object);
        }
        return stageSummary;
    }

    private void raiseException(String message) {
        throw new BuildException(message);
    }

    private void startNewStage(String stageName, Stage newStage, Long startTime) {
        if (!this.currentStages.containsKey(stageName)) {
            this.currentStages.put(stageName, newStage);
            this.currentStagesStartTime.put(stageName, startTime);
            this.log.debug((Object)("New stage [" + stageName + "] started at " + this.getTimestamp(startTime)));
        }
    }

    private void endCurrentStage(String currentStageName, Stage currentStage, String reason, Long currTime) {
        if (currentStage != null) {
            BuildStatusReport report = this.constructBuildStatusReport(currentStageName, this.currentStagesStartTime.get(currentStageName), currTime, reason);
            this.statusReports.add(report);
            this.displaySummary = true;
            this.log.debug((Object)("Stage [" + currentStageName + "] finished at " + this.getTimestamp(currTime)));
            this.reset(currentStageName);
        }
    }

    private void reset(String stageName) {
        this.currentStages.remove(stageName);
        this.currentStagesStartTime.remove(stageName);
        this.completedStages.add(stageName);
    }

    private TreeMap<String, Stage> searchNewStage(BuildEvent event) {
        TreeMap<String, Stage> result = new TreeMap<String, Stage>();
        String target = event.getTarget().getName();
        for (String stageName : this.stages.keySet()) {
            Stage stage = this.stages.get(stageName);
            if (this.completedStages.contains(stageName) || !this.isStartingTarget(target, event.getProject(), stage)) continue;
            result.put(stageName, stage);
            break;
        }
        return result;
    }

    private boolean isStartingTarget(String targetName, Project project, Stage stage) {
        Vector dependencies;
        boolean bool = false;
        if (project.getTargets().containsKey(stage.getStartTarget()) && !(dependencies = project.topoSort(stage.getStartTarget(), project.getTargets(), false)).isEmpty()) {
            Target target = (Target)dependencies.firstElement();
            bool = target.getName().equals(targetName);
        }
        return bool;
    }

    private void parseStages(Project project) {
        this.stages = new Hashtable();
        Hashtable references = project.getReferences();
        Enumeration en = references.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object value = references.get(key);
            if (!(value instanceof Stage)) continue;
            this.stages.put(key, (Stage)((Object)value));
        }
    }

    private String getReason(Throwable th) {
        return th != null ? th.getMessage() : "";
    }

    private Long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private void generateSummary(Project project) {
        if (this.template != null) {
            try {
                Configuration cfg = new Configuration();
                StringTokenizer tokenizer = new StringTokenizer(this.template, File.separator);
                StringBuffer baseDirBuf = new StringBuffer();
                String templateName = null;
                while (tokenizer.hasMoreElements()) {
                    String str = (String)tokenizer.nextElement();
                    if (str.endsWith(".ftl")) {
                        templateName = str;
                        continue;
                    }
                    baseDirBuf.append(str).append(File.separator);
                }
                File baseDir = new File(baseDirBuf.toString());
                cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(baseDir));
                Template templ = cfg.getTemplate(templateName);
                StringWriter writer = new StringWriter();
                templ.process(this.getTemplateData(), (Writer)writer);
                project.log(writer.toString());
            }
            catch (InvalidReferenceException ivx) {
                project.log("Invalid reference in config: ", (Throwable)ivx, 1);
            }
            catch (TemplateException e2) {
                project.log("TemplateException: ", (Throwable)e2, 1);
            }
            catch (IOException e) {
                project.log("I/O Error during template conversion: ", (Throwable)e, 1);
            }
        }
    }

    private Map<String, Object> getTemplateData() {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        templateMap.put("statusReports", new ArrayList<BuildStatusReport>(this.statusReports));
        return templateMap;
    }

    private String getTimestamp(long date) {
        Date dt = new Date(date);
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        String finishTime = formatter.format(dt);
        return finishTime;
    }

    private String getTimeElapsed(Long startTime, Long endTime) {
        long timeElapsed = endTime - startTime;
        return DateUtils.formatElapsedTime((long)timeElapsed);
    }

    private BuildStatusReport constructBuildStatusReport(String phaseName, Long startTime, Long endTime, String reason) {
        return new BuildStatusReport(phaseName, this.getTimestamp(startTime), this.getTimeElapsed(startTime, endTime), reason);
    }
}

