/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.listener.internaldata;

import com.nokia.ant.Database;
import com.nokia.ant.listener.internaldata.AssertNode;
import com.nokia.ant.listener.internaldata.BuildNode;
import com.nokia.ant.listener.internaldata.DataNode;
import com.nokia.ant.listener.internaldata.EmailDataSender;
import com.nokia.ant.listener.internaldata.EndLessStack;
import com.nokia.ant.listener.internaldata.TargetNode;
import com.nokia.ant.listener.internaldata.XMLRenderer;
import com.nokia.ant.taskdefs.HlmAssertMessage;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Date;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.dom4j.Document;

public class Listener
implements BuildListener,
SubBuildListener {
    private Logger log;
    private boolean sendDatabase = true;
    private BuildNode buildNode;
    private EndLessStack<DataNode> buildEventStack = new EndLessStack();
    private String[] propList = new String[]{"os.name", "user.name", "build.name", "build.number", "build.id", "build.family", "build.system", "env.NUMBER_OF_PROCESSORS", "helium.version", "env.SYMSEE_VERSION", "diamonds.build.id"};
    private MemoryMXBean mbean;

    public Listener() {
        this.log = Logger.getLogger(Listener.class);
        this.mbean = ManagementFactory.getMemoryMXBean();
    }

    public void sendData(String smtpServer, BuildEvent event) {
        if (this.buildNode != null) {
            Document database = null;
            if (this.sendDatabase) {
                try {
                    Database antDB = new Database((Project)this.buildNode.getReference(), null, null);
                    database = antDB.createDOM();
                }
                catch (Exception e) {
                    this.log.debug((Object)"Error: couldn't generate Ant DB.", (Throwable)e);
                    database = null;
                }
            }
            try {
                this.log.debug((Object)"Creating the XML log.");
                XMLRenderer writer = new XMLRenderer(this.buildNode, database, this.extractProperties(), event);
                EmailDataSender sender = new EmailDataSender();
                sender.setSMTPServer(smtpServer);
                this.log.debug((Object)"Sending the data.");
                String xml = writer.toString();
                this.log.debug((Object)xml);
                sender.sendData(xml);
            }
            catch (Exception e) {
                this.log.debug((Object)"Error: error generating the InterData database XML.", (Throwable)e);
            }
        }
    }

    private Hashtable<String, String> extractProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (this.buildNode != null) {
            Project project = (Project)this.buildNode.getReference();
            Hashtable projProps = project.getProperties();
            for (int i = 0; i < this.propList.length; ++i) {
                if (!projProps.containsKey(this.propList[i])) continue;
                properties.put(this.propList[i], (String)projProps.get(this.propList[i]));
            }
        }
        return properties;
    }

    public synchronized void buildFinished(BuildEvent event) {
        BuildNode node;
        this.log.debug((Object)"buildFinished");
        if (this.buildNode != null && (node = (BuildNode)this.buildNode.find(event.getProject())) != null) {
            node.setEndTime(new Date());
            node.setSuccessful(event.getException() == null);
        }
        String smtpServer = event.getProject().getProperty("email.smtp.server");
        this.sendData(smtpServer, event);
    }

    public synchronized void buildStarted(BuildEvent event) {
        if (this.buildNode == null) {
            this.buildNode = new BuildNode(null, event.getProject());
            this.buildEventStack.setDefaultElement(this.buildNode);
        }
    }

    public synchronized void subBuildFinished(BuildEvent event) {
        if (this.buildNode != null) {
            BuildNode node = (BuildNode)this.buildNode.find(event.getProject());
            if (node != null) {
                node.setEndTime(new Date());
                node.setReference(null);
                node.setSuccessful(event.getException() == null);
            } else {
                this.log.debug((Object)"subBuildFinished - could not find subbuild.");
            }
            this.buildEventStack.pop();
        }
    }

    public synchronized void subBuildStarted(BuildEvent event) {
        DataNode parentNode = this.buildEventStack.peek();
        if (parentNode != null) {
            BuildNode node = new BuildNode(parentNode, event.getProject());
            this.buildEventStack.push(node);
        }
    }

    public void messageLogged(BuildEvent event) {
    }

    public synchronized void targetFinished(BuildEvent event) {
        if (this.buildNode != null) {
            DataNode node = this.buildNode.find(event.getTarget());
            if (node != null) {
                node.setEndTime(new Date());
                MemoryUsage mem = this.mbean.getHeapMemoryUsage();
                TargetNode tnode = (TargetNode)node;
                tnode.setEndUsedHeap(mem.getUsed());
                tnode.setEndCommittedHeap(mem.getCommitted());
                node.setReference(null);
            } else {
                this.log.debug((Object)"targetFinished - could not find target.");
            }
            this.buildEventStack.pop();
        }
    }

    public synchronized void targetStarted(BuildEvent event) {
        DataNode parentNode = this.buildEventStack.peek();
        if (parentNode != null) {
            TargetNode node = new TargetNode(parentNode, event.getTarget());
            MemoryUsage mem = this.mbean.getHeapMemoryUsage();
            node.setStartUsedHeap(mem.getUsed());
            node.setStartCommittedHeap(mem.getCommitted());
            this.buildEventStack.push(node);
        } else {
            this.log.debug((Object)"targetStarted - could not find parent.");
        }
    }

    public synchronized void taskFinished(BuildEvent event) {
    }

    public synchronized void taskStarted(BuildEvent event) {
    }

    public void addAssertTask(HlmAssertMessage assertTask) {
        if (this.buildNode != null) {
            DataNode parentNode = this.buildNode.find(assertTask.getOwningTarget());
            if (parentNode != null) {
                new AssertNode(parentNode, assertTask);
            } else {
                new AssertNode(this.buildEventStack.peek(), assertTask);
            }
        }
    }
}

