/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;

public final class AbstractClassNameCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^Abstract.*$|^.*Factory$";

    public AbstractClassNameCheck() {
        super(DEFAULT_FORMAT);
    }

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 14: {
                this.visitClassDef(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void visitClassDef(DetailAST aAST) {
        String className;
        if (this.isAbstract(aAST) && !this.isMatchingClassName(className = aAST.findFirstToken(58).getText())) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "illegal.abstract.class.name", className, this.getFormat());
        }
    }

    private boolean isAbstract(DetailAST aAST) {
        DetailAST abstractAST = aAST.findFirstToken(5).findFirstToken(40);
        return abstractAST != null;
    }

    private boolean isMatchingClassName(String aClassName) {
        return this.getRegexp().matcher(aClassName).find();
    }
}

