/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.instr;

import com.vladium.emma.ant.StringValue;
import com.vladium.emma.ant.SuppressableTask;
import com.vladium.util.IConstants;
import com.vladium.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class FilterCfg {
    protected static final String COMMA = ",";
    protected static final String COMMA_DELIMITERS = ", \t\r\n";
    protected static final String PATH_DELIMITERS = ",".concat(File.pathSeparator);
    private final Task m_task;
    private final List m_filterList;
    private transient String[] m_specs;

    public FilterCfg(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("null input: task");
        }
        this.m_task = task;
        this.m_filterList = new ArrayList();
    }

    public void setFilter(String filter) {
        this.createFilter().appendValue(filter, COMMA);
    }

    public filterElement createFilter() {
        filterElement result = new filterElement(this.m_task);
        this.m_filterList.add(result);
        return result;
    }

    public String[] getFilterSpecs() {
        if (this.m_specs != null) {
            return this.m_specs;
        }
        if (this.m_filterList == null || this.m_filterList.isEmpty()) {
            this.m_specs = IConstants.EMPTY_STRING_ARRAY;
        } else {
            String[] values = new String[this.m_filterList.size()];
            int j = 0;
            Iterator i = this.m_filterList.iterator();
            while (i.hasNext()) {
                values[j] = ((StringValue)i.next()).getValue();
                ++j;
            }
            try {
                this.m_specs = Strings.mergeAT((String[])values, (String)COMMA_DELIMITERS, (boolean)true);
            }
            catch (IOException ioe) {
                throw (BuildException)SuppressableTask.newBuildException(this.m_task.getTaskName() + ": I/O exception while processing input", ioe, this.m_task.getLocation()).fillInStackTrace();
            }
        }
        return this.m_specs;
    }

    public static final class filterElement
    extends StringValue {
        public filterElement(Task task) {
            super(task);
        }

        public void setValue(String value) {
            String[] specs = Strings.merge((String[])new String[]{value}, (String)FilterCfg.COMMA_DELIMITERS, (boolean)true);
            for (int i = 0; i < specs.length; ++i) {
                String spec = specs[i];
                if (spec.startsWith("+") || spec.startsWith("-")) {
                    this.appendValue(spec, FilterCfg.COMMA);
                    continue;
                }
                this.appendValue('+' + spec, FilterCfg.COMMA);
            }
        }

        public void setFile(File file) {
            this.appendValue("@".concat(file.getAbsolutePath()), FilterCfg.COMMA);
        }

        public void setIncludes(String value) {
            String[] specs = Strings.merge((String[])new String[]{value}, (String)FilterCfg.COMMA_DELIMITERS, (boolean)true);
            for (int i = 0; i < specs.length; ++i) {
                String spec = specs[i];
                if (spec.startsWith("+")) {
                    this.appendValue(spec, FilterCfg.COMMA);
                    continue;
                }
                if (spec.startsWith("-")) {
                    this.appendValue('+' + spec.substring(1), FilterCfg.COMMA);
                    continue;
                }
                this.appendValue('+' + spec, FilterCfg.COMMA);
            }
        }

        public void setExcludes(String value) {
            String[] specs = Strings.merge((String[])new String[]{value}, (String)FilterCfg.COMMA_DELIMITERS, (boolean)true);
            for (int i = 0; i < specs.length; ++i) {
                String spec = specs[i];
                if (spec.startsWith("-")) {
                    this.appendValue(spec, FilterCfg.COMMA);
                    continue;
                }
                if (spec.startsWith("+")) {
                    this.appendValue('-' + spec.substring(1), FilterCfg.COMMA);
                    continue;
                }
                this.appendValue('-' + spec, FilterCfg.COMMA);
            }
        }
    }
}

