/*
 * Decompiled with CFR 0.152.
 */
package fmpp;

import fmpp.Engine;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;

class FmppTemplateLoader
implements TemplateLoader {
    private static final boolean SEP_IS_SLASH = File.separatorChar == '/';
    private final Engine engine;

    public FmppTemplateLoader(Engine engine) throws IOException {
        this.engine = engine;
    }

    public Object findTemplateSource(String name) throws IOException {
        if (name.indexOf(92) != -1) {
            throw new IOException("Malformed path. FreeMarker paths use slash (/) to separate path components, not backslash (\\). Please replace backslashes with slashes in this path: " + name);
        }
        String nativeName = SEP_IS_SLASH ? name : name.replace('/', File.separatorChar);
        File source = new File(this.engine.getSourceRoot(), nativeName);
        if (source.isFile()) {
            return source;
        }
        if (name.startsWith("@")) {
            String linkName;
            int i = name.indexOf("/");
            if (i != -1) {
                linkName = name.substring(1, i);
                nativeName = nativeName.substring(i + 1);
            } else {
                linkName = name.substring(1);
                nativeName = null;
            }
            List links = this.engine.getFreemarkerLink(linkName);
            if (links != null) {
                int ln = links.size();
                for (i = 0; i < ln; ++i) {
                    source = nativeName != null ? new File((File)links.get(i), nativeName) : (File)links.get(i);
                    if (!source.isFile()) continue;
                    return source;
                }
            }
        }
        return null;
    }

    public long getLastModified(Object templateSource) {
        return ((File)templateSource).lastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return this.engine.wrapReader(new InputStreamReader((InputStream)new FileInputStream((File)templateSource), encoding), (File)templateSource);
    }

    public void closeTemplateSource(Object templateSource) {
    }
}

