/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.info;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public final class ProductVersionHolder
implements PrivilegedAction {
    private static final int BAD_NUMBER = -1;
    private static final String ALPHA = "alpha";
    private static final String BETA = "beta";
    private static final int MAINT_ENCODING = 1000000;
    private String productVendorName;
    private String productName;
    private String productTechnologyName;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int maintVersion = -1;
    private int drdaMaintVersion = -1;
    private String buildNumber = "????";
    private Boolean isBeta;
    private String productGenus;

    private ProductVersionHolder() {
    }

    private ProductVersionHolder(String string, String string2, String string3, int n, int n2, int n3, int n4, String string4, Boolean bl) {
        if (string != null) {
            this.productVendorName = string.trim();
        }
        if (string2 != null) {
            this.productName = string2.trim();
        }
        if (string3 != null) {
            this.productTechnologyName = string3.trim();
        }
        this.majorVersion = n;
        this.minorVersion = n2;
        this.maintVersion = n3;
        this.drdaMaintVersion = n4;
        this.buildNumber = string4;
        this.isBeta = bl;
    }

    public static ProductVersionHolder getProductVersionHolder(String string, String string2, String string3, int n, int n2, int n3, int n4, String string4, Boolean bl) {
        ProductVersionHolder productVersionHolder = new ProductVersionHolder(string, string2, string3, n, n2, n3, n4, string4, bl);
        return productVersionHolder;
    }

    public static ProductVersionHolder getProductVersionHolderFromMyEnv(String string) {
        ProductVersionHolder productVersionHolder = new ProductVersionHolder();
        productVersionHolder.productGenus = string;
        Properties properties = (Properties)AccessController.doPrivileged(productVersionHolder);
        if (properties == null) {
            return null;
        }
        return ProductVersionHolder.getProductVersionHolder(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProductVersionHolder getProductVersionHolderFromMyEnv(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            System.out.println("IOE " + iOException.getMessage());
            ProductVersionHolder productVersionHolder = null;
            return productVersionHolder;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return ProductVersionHolder.getProductVersionHolder(properties);
    }

    public static ProductVersionHolder getProductVersionHolder(Properties properties) {
        String string = properties.getProperty("derby.product.vendor");
        String string2 = properties.getProperty("derby.product.external.name");
        String string3 = properties.getProperty("derby.product.technology.name");
        int n = ProductVersionHolder.parseInt(properties.getProperty("derby.version.major"));
        int n2 = ProductVersionHolder.parseInt(properties.getProperty("derby.version.minor"));
        int n3 = ProductVersionHolder.parseInt(properties.getProperty("derby.version.maint"));
        int n4 = ProductVersionHolder.parseInt(properties.getProperty("derby.version.drdamaint"));
        String string4 = properties.getProperty("derby.build.number");
        Boolean bl = Boolean.valueOf(properties.getProperty("derby.version.beta"));
        return ProductVersionHolder.getProductVersionHolder(string, string2, string3, n, n2, n3, n4, string4, bl);
    }

    public String getProductVendorName() {
        return this.productVendorName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductTechnologyName() {
        return this.productTechnologyName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMaintVersion() {
        return this.maintVersion;
    }

    public int getDrdaMaintVersion() {
        return this.drdaMaintVersion;
    }

    public int getFixPackVersion() {
        return this.maintVersion / 1000000;
    }

    public boolean isBeta() {
        return this.isBeta;
    }

    public boolean isAlpha() {
        return this.majorVersion >= 5 && this.minorVersion > 2 && this.maintVersion / 1000000 == 0;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public int getBuildNumberAsInt() {
        if (this.buildNumber == null) {
            return -1;
        }
        boolean bl = false;
        int n = this.buildNumber.indexOf(77);
        if (n == -1) {
            n = this.buildNumber.indexOf(58);
        } else {
            bl = true;
        }
        if (n == -1) {
            n = this.buildNumber.length();
        } else {
            bl = true;
        }
        try {
            int n2 = Integer.parseInt(this.buildNumber.substring(0, n));
            if (bl) {
                n2 = -n2;
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static int parseInt(String string) {
        int n = -1;
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 0) {
            n = -1;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProductVendorName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getProductName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getVersionBuildString(true));
        return stringBuffer.toString();
    }

    public String getSimpleVersionString() {
        return ProductVersionHolder.simpleVersionString(this.majorVersion, this.minorVersion, this.isBeta());
    }

    public static String simpleVersionString(int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append('.');
        stringBuffer.append(n2);
        if (bl) {
            stringBuffer.append(' ');
            stringBuffer.append(BETA);
        }
        return stringBuffer.toString();
    }

    public static String fullVersionString(int n, int n2, int n3, boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append('.');
        stringBuffer.append(n2);
        stringBuffer.append('.');
        String string2 = null;
        if (n == 5 && n2 <= 2 && n3 < 1000000) {
            stringBuffer.append(n3);
            if (bl) {
                string2 = BETA;
            }
        } else {
            int n4 = n3 / 1000000;
            int n5 = n3 % 1000000;
            stringBuffer.append(n4);
            stringBuffer.append('.');
            stringBuffer.append(n5);
            if (n4 == 0) {
                string2 = ALPHA;
            } else if (bl) {
                string2 = BETA;
            }
        }
        if (string2 != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        if (string != null) {
            stringBuffer.append(" - (");
            stringBuffer.append(string);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String getVersionBuildString(boolean bl) {
        return ProductVersionHolder.fullVersionString(this.majorVersion, this.minorVersion, this.maintVersion, this.isBeta(), bl ? this.buildNumber : null);
    }

    public final Object run() {
        return this.loadProperties(this.productGenus);
    }

    private Properties loadProperties(String string) {
        String string2 = "/org/apache/derby/info/" + string + ".properties";
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

