/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.diamonds;

import com.nokia.helium.core.EmailDataSender;
import com.nokia.helium.diamonds.DiamondsException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DiamondsClient {
    private static final int INT_SERV_ERROR = 500;
    private static final int SERV_NOT_FOUND = 404;
    private static final int SERV_OK = 200;
    private boolean isRecordOnly;
    private Logger log = Logger.getLogger(DiamondsClient.class);
    private String host;
    private String port;
    private String path;
    private String emailID;
    private HttpClient httpClient;

    public DiamondsClient(String hst, String prt, String pth, String mailID) {
        this.host = hst;
        this.port = prt;
        this.path = pth;
        this.emailID = mailID;
        this.httpClient = new HttpClient();
    }

    private int executeMethod(PostMethod postMethod) throws DiamondsException {
        int result = 0;
        try {
            result = this.httpClient.executeMethod((HttpMethod)postMethod);
        }
        catch (IOException e) {
            this.log.info((Object)"IOException while sending http request");
            this.log.debug((Object)"IOException while sending http request: ", (Throwable)e);
            this.isRecordOnly = true;
            throw new DiamondsException("Exception in executeMethod");
        }
        return result;
    }

    private String checkForProtocol(String url) throws DiamondsException {
        String retURL = url;
        try {
            if (!StringUtils.containsIgnoreCase((String)url, (String)"http://")) {
                retURL = "http://" + url;
            }
        }
        catch (Exception ex) {
            this.isRecordOnly = true;
            this.log.info((Object)"Failed to check url, defaulting to input.");
            throw new DiamondsException("Exception verifying URL");
        }
        return retURL;
    }

    private String getURL() throws DiamondsException {
        return this.getURL(null);
    }

    private String getURL(String subPath) throws DiamondsException {
        String urlPath = this.path;
        if (subPath != null) {
            urlPath = subPath;
        }
        return this.checkForProtocol("http://" + this.host + ":" + this.port + urlPath);
    }

    private PostMethod getPostMethod(String fileName, String urlPath) {
        File input = new File(fileName);
        PostMethod post = new PostMethod(urlPath);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        return post;
    }

    private int processPostMethodResult(int result) {
        switch (result) {
            case 500: {
                break;
            }
            case 404: {
                break;
            }
            case 200: {
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBuildId(String fileName) throws DiamondsException {
        String diamondsBuildID = null;
        PostMethod postMethod = null;
        try {
            if (!this.isRecordOnly) {
                String strURL = this.getURL();
                this.log.debug((Object)("strURL:" + strURL));
                postMethod = this.getPostMethod(fileName, strURL);
                this.log.debug((Object)("postmethod:" + postMethod));
                int postMethodResult = this.httpClient.executeMethod((HttpMethod)postMethod);
                this.log.debug((Object)("postmethod-result:" + postMethodResult));
                int result = this.processPostMethodResult(postMethodResult);
                if (result == 200) {
                    diamondsBuildID = postMethod.getResponseBodyAsString();
                    this.log.debug((Object)("diamondsBuildID: " + diamondsBuildID));
                } else {
                    this.isRecordOnly = true;
                    this.log.debug((Object)"Connection Failed.");
                    this.log.info((Object)"Diamonds data not sent, because of connection failure.");
                }
            }
        }
        catch (HttpException ex) {
            this.isRecordOnly = true;
            this.log.debug((Object)"Connection Failed", (Throwable)ex);
            this.log.info((Object)"Diamonds data not sent, because of httpexception.");
        }
        catch (IOException ex1) {
            this.isRecordOnly = true;
            this.log.debug((Object)"Connection Failed. ", (Throwable)ex1);
            this.log.info((Object)"Diamonds data not sent, because of io exception.");
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return diamondsBuildID;
    }

    public int sendData(String fileName, String urlPath) {
        PostMethod postMethod = null;
        int result = -1;
        if (urlPath != null && !this.isRecordOnly) {
            try {
                String strURL = this.getURL(urlPath);
                postMethod = this.getPostMethod(fileName, strURL);
                result = this.processPostMethodResult(this.httpClient.executeMethod((HttpMethod)postMethod));
            }
            catch (Exception e) {
                this.log.debug((Object)"DiamondsClient:sendData by Http: ", (Throwable)e);
                this.log.info((Object)"The final data via http not sent because errors: ", (Throwable)e);
            }
        }
        return result;
    }

    public int sendDataByMail(String fileName, String smtpServer, String ldapServer) {
        this.log.debug((Object)("DiamondsClient:sendDataByEmail:emailID" + this.emailID));
        EmailDataSender emailSender = new EmailDataSender(this.emailID, smtpServer, ldapServer);
        try {
            this.log.debug((Object)("DiamondsClient:sendDataByEmail: " + fileName));
            emailSender.sendData("diamonds", fileName, "application/xml", "[DIAMONDS_DATA]", null);
            this.log.debug((Object)"DiamondsClient:sendDataByEmail:succeeds");
        }
        catch (Exception e) {
            this.log.debug((Object)"DiamondsClient:sendDataByEmail: ", (Throwable)e);
            this.log.info((Object)"The final data via http not sent because errors: ", (Throwable)e);
            return -1;
        }
        return 0;
    }
}

