/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.cruisecontrol.dashboard.widgets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import net.sourceforge.cruisecontrol.dashboard.widgets.Widget;

public class HeliumSummary
implements Widget {
    public String getDisplayName() {
        return "Helium summary";
    }

    public Object getOutput(Map parameters) {
        String output = "Error retreiving logs.";
        try {
            File projectLogDir = this.findHeliumLogDir(parameters);
            if (projectLogDir.exists()) {
                File log = this.findCCLog(projectLogDir);
                if (log != null) {
                    String s;
                    FileReader fr = new FileReader(log);
                    BufferedReader br = new BufferedReader(fr);
                    output = "";
                    while ((s = br.readLine()) != null) {
                        output = output + s;
                    }
                    fr.close();
                } else {
                    output = "Could not find CC summary.";
                }
            } else {
                output = "Could not find " + projectLogDir.getAbsolutePath();
            }
        }
        catch (Exception e) {
            return e.toString();
        }
        return output;
    }

    protected File findCCLog(File location) {
        if (location.exists() && location.isDirectory()) {
            File[] list = location.listFiles();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    File result = this.findCCLog(list[i]);
                    if (result == null) continue;
                    return result;
                }
                if (!list[i].getName().toLowerCase().endsWith("_cc_summary.html")) continue;
                return list[i];
            }
        }
        return null;
    }

    protected File findHeliumLogDir(Map parameters) throws Exception {
        File projectLogDir = (File)parameters.get("BUILD_ARTIFACTS_ROOT");
        if (projectLogDir != null) {
            return projectLogDir;
        }
        throw new Exception("Could not retieve the log directory.");
    }
}

