/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.diamonds;

import com.nokia.helium.core.PropertiesSource;
import com.nokia.helium.core.TemplateProcessorException;
import com.nokia.helium.core.XMLTemplateSource;
import com.nokia.helium.diamonds.DiamondsConfig;
import com.nokia.helium.diamonds.DiamondsException;
import com.nokia.helium.diamonds.DiamondsListenerImpl;
import com.nokia.helium.diamonds.Stage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;

public class StageDiamondsListener
extends DiamondsListenerImpl {
    private static final Date INVALID_DATE = new Date(-1L);
    private Logger log = Logger.getLogger(StageDiamondsListener.class);
    private List<Map<String, Date>> stageTargetBeginList = new ArrayList<Map<String, Date>>();
    private Map<String, Stage> stageTargetEndMap = new HashMap<String, Stage>();
    private boolean isTargetMapInitialized;
    private Project project;
    private String currentStartTargetName;
    private List<Stage> stages = DiamondsConfig.getStages();
    private Date currentStartTargetTime;

    @Override
    public void targetBegin(BuildEvent buildEvent) throws DiamondsException {
        this.project = buildEvent.getProject();
        String targetName = buildEvent.getTarget().getName();
        if (!this.isTargetMapInitialized && this.stages != null) {
            this.log.debug((Object)"diamonds:StageDiamondsListener: initializing for all stages.");
            this.initStageTargetsMap();
            this.isTargetMapInitialized = true;
        }
        this.log.debug((Object)("targetBegin targetName: " + targetName + " - currentStartTargetName:" + this.currentStartTargetName));
        if (this.currentStartTargetName == null) {
            this.findAndSetStartTimeForTargetInStageList(targetName);
        }
    }

    @Override
    public void targetEnd(BuildEvent buildEvent) throws DiamondsException {
        String targetName;
        Stage stage;
        if (this.currentStartTargetName != null && (stage = this.stageTargetEndMap.get(targetName = buildEvent.getTarget().getName())) != null && this.getIsInitialized()) {
            ArrayList<Object> sourceList;
            String output;
            String stageName = stage.getStageName();
            String sourceFile = stage.getSourceFile();
            this.log.debug((Object)("diamonds:StageDiamondsListener: finished recording for stage: " + stageName));
            if (sourceFile == null) {
                sourceFile = this.getSourceFile(stageName);
            }
            this.project.setProperty("logical.stage", stageName);
            this.project.setProperty("stage.start.time", this.getTimeFormat().format(this.currentStartTargetTime));
            this.project.setProperty("stage.end.time", this.getTimeFormat().format(new Date()));
            this.currentStartTargetName = null;
            String stageTemplateFileName = stageName + ".xml.ftl";
            File stageTemplateFile = new File(stageTemplateFileName);
            if (stageTemplateFile.exists()) {
                output = DiamondsConfig.getOutputDir() + File.separator + stageName + ".xml";
                try {
                    sourceList = new ArrayList<Object>();
                    sourceList.add(new PropertiesSource("ant", (Map)this.project.getProperties()));
                    sourceList.add(new XMLTemplateSource("doc", new File(sourceFile)));
                    this.getTemplateProcessor().convertTemplate(DiamondsConfig.getTemplateDir(), stageTemplateFileName, output, sourceList);
                    StageDiamondsListener.mergeToFullResults(new File(output));
                    this.log.info((Object)("Sending data to diamonds for stage: " + stageName));
                    this.getDiamondsClient().sendData(output, DiamondsConfig.getDiamondsProperties().getDiamondsBuildID());
                }
                catch (TemplateProcessorException e1) {
                    throw new DiamondsException("template conversion error for stage: " + stageName + " : " + e1.getMessage());
                }
            } else {
                this.log.debug((Object)("diamonds:StageDiamondsListener:tempalte file: " + stageTemplateFile + " does not exist"));
            }
            output = DiamondsConfig.getOutputDir() + File.separator + stageName + "-time.xml";
            stageTemplateFileName = "diamonds_stage.xml.ftl";
            try {
                sourceList = new ArrayList();
                sourceList.add(new PropertiesSource("ant", (Map)this.project.getProperties()));
                sourceList.add(new XMLTemplateSource("doc", new File(sourceFile)));
                this.getTemplateProcessor().convertTemplate(DiamondsConfig.getTemplateDir(), stageTemplateFileName, output, sourceList);
                StageDiamondsListener.mergeToFullResults(new File(output));
                this.getDiamondsClient().sendData(output, DiamondsConfig.getDiamondsProperties().getDiamondsBuildID());
            }
            catch (TemplateProcessorException e1) {
                throw new DiamondsException("template conversion error while sending data for stage: " + stageName + " : " + e1.getMessage());
            }
        }
    }

    private void findAndSetStartTimeForTargetInStageList(String targetName) throws DiamondsException {
        for (Map<String, Date> stageMap : this.stageTargetBeginList) {
            Date targetTime = stageMap.get(targetName);
            if (targetTime == null || !targetTime.equals(INVALID_DATE)) continue;
            this.log.debug((Object)("diamonds:StageDiamondsListener: started recording for stage-target: " + targetName));
            stageMap.put(targetName, new Date());
            this.currentStartTargetName = targetName;
            this.currentStartTargetTime = new Date();
        }
    }

    private void initStageTargetsMap() {
        for (Stage stage : this.stages) {
            String startTargetName = stage.getStartTargetName();
            HashMap<String, Date> stageMap = new HashMap<String, Date>();
            Vector arrayList = null;
            try {
                arrayList = this.project.topoSort(startTargetName, this.project.getTargets(), false);
            }
            catch (BuildException be) {
                this.log.debug((Object)"Diamonds target missing: ", (Throwable)be);
            }
            if (arrayList == null) continue;
            this.log.debug((Object)(" + Stage definition: " + stage.getStageName()));
            Enumeration targetEnum = arrayList.elements();
            while (targetEnum.hasMoreElements()) {
                Target target = (Target)targetEnum.nextElement();
                stageMap.put(target.getName(), INVALID_DATE);
                this.log.debug((Object)("   - Start target: " + target.getName()));
            }
            this.stageTargetBeginList.add(stageMap);
            String endTargetName = stage.getEndTargetName();
            this.stageTargetEndMap.put(endTargetName, stage);
            this.log.debug((Object)("   - End target: " + endTargetName));
        }
    }
}

