/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core.ant.types;

import com.nokia.helium.core.ant.VariableIFImpl;
import com.nokia.helium.core.ant.types.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;

public class VariableSet
extends VariableIFImpl {
    private static Logger log = Logger.getLogger(VariableSet.class);
    private HashMap<String, Variable> variablesMap = new HashMap();
    private List<Variable> variables = new ArrayList<Variable>();
    private Vector<VariableSet> varSets = new Vector();
    private VariableSet currentSet;

    public void add(VariableSet varSet) {
        this.currentSet = null;
        if (varSet != null) {
            this.varSets.add(varSet);
        }
    }

    public VariableSet createArgSet() {
        VariableSet varSet = new VariableSet();
        this.add(varSet);
        return varSet;
    }

    public Variable createArg() {
        Variable var = new Variable();
        this.add(var);
        return var;
    }

    private void addVariable(Variable var) {
        this.variables.add(var);
    }

    public void add(Variable var) {
        if (this.currentSet == null) {
            this.currentSet = new VariableSet();
            this.varSets.add(this.currentSet);
        }
        this.currentSet.addVariable(var);
    }

    public List<Variable> getVariablesList() {
        return this.variables;
    }

    public List<VariableSet> getVariableSets() {
        return this.varSets;
    }

    @Override
    public Collection<Variable> getVariables() {
        HashMap<String, Variable> varMap = this.getVariablesMap();
        return this.getVariablesMap().values();
    }

    public HashMap<String, Variable> getVariablesMap() {
        HashMap<String, Variable> allVariables = new HashMap<String, Variable>();
        Reference refId = this.getRefid();
        Object varSetObject = null;
        if (refId != null) {
            try {
                varSetObject = refId.getReferencedObject();
            }
            catch (Exception ex) {
                log.debug((Object)"exception in getting variable", (Throwable)ex);
                throw new BuildException("Not found: " + ex.getMessage());
            }
            if (varSetObject != null && varSetObject instanceof VariableSet) {
                HashMap<String, Variable> varSetMap = ((VariableSet)((Object)varSetObject)).getVariablesMap();
                allVariables.putAll(varSetMap);
            }
        }
        if (this.varSets != null && !this.varSets.isEmpty()) {
            for (VariableSet varSet : this.varSets) {
                HashMap<String, Variable> variablesMap = varSet.getVariablesMap();
                allVariables.putAll(variablesMap);
            }
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            for (Variable var : this.variables) {
                allVariables.put(var.getName(), var);
            }
        }
        return allVariables;
    }
}

