/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.htmlcleaner.CommentToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XmlSerializer;

public class PrettyXmlSerializer
extends XmlSerializer {
    private static final String INDENTATION_STRING = "\t";

    protected PrettyXmlSerializer(Writer writer, HtmlCleaner htmlCleaner) {
        super(writer, htmlCleaner);
    }

    protected void serialize(TagNode tagNode) throws IOException {
        this.serializePrettyXml(tagNode, 0);
    }

    private String indent(int level) {
        String result = "";
        while (level > 0) {
            result = String.valueOf(result) + INDENTATION_STRING;
            --level;
        }
        return result;
    }

    private String getIndentedText(String content, int level) {
        String indent = this.indent(level);
        StringBuffer result = new StringBuffer(content.length());
        StringTokenizer tokenizer = new StringTokenizer(content, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if ("".equals(line)) continue;
            result.append(String.valueOf(indent) + line + "\n");
        }
        return result.toString();
    }

    private String getSingleLineOfChildren(List children) {
        StringBuffer result = new StringBuffer();
        Iterator childrenIt = children.iterator();
        boolean isFirst = true;
        while (childrenIt.hasNext()) {
            Object child = childrenIt.next();
            if (!(child instanceof ContentToken)) {
                return null;
            }
            ContentToken contentToken = (ContentToken)child;
            String content = contentToken.getContent();
            if (isFirst) {
                content = Utils.ltrim(content);
            }
            if (!childrenIt.hasNext()) {
                content = Utils.rtrim(content);
            }
            if (content.indexOf("\n") >= 0 || content.indexOf("\r") >= 0) {
                return null;
            }
            result.append(content);
            isFirst = false;
        }
        return result.toString();
    }

    private void serializePrettyXml(List nodes, int level, boolean dontEscape) throws IOException {
        for (Object child : nodes) {
            String content;
            if (child instanceof TagNode) {
                this.serializePrettyXml((TagNode)child, level + 1);
                continue;
            }
            if (child instanceof ContentToken) {
                ContentToken contentToken = (ContentToken)child;
                content = contentToken.getContent();
                content = !dontEscape ? this.escapeXml(content) : content.replaceAll("]]>", "]]&amp;");
                this.writer.write(this.getIndentedText(content, level + 1));
                continue;
            }
            if (child instanceof CommentToken) {
                CommentToken commentToken = (CommentToken)child;
                content = commentToken.getContent();
                this.writer.write(this.getIndentedText(content, level + 1));
                continue;
            }
            if (!(child instanceof List)) continue;
            this.serializePrettyXml((List)child, level, true);
        }
    }

    protected void serializePrettyXml(TagNode tagNode, int level) throws IOException {
        List tagChildren = tagNode.getChildren();
        String indent = this.indent(level);
        this.writer.write(indent);
        this.serializeOpenTag(tagNode);
        if (!tagChildren.isEmpty()) {
            String singleLine = this.getSingleLineOfChildren(tagChildren);
            boolean dontEscape = this.dontEscape(tagNode);
            if (singleLine != null) {
                if (!this.dontEscape(tagNode)) {
                    this.writer.write(this.escapeXml(singleLine));
                } else {
                    this.writer.write(singleLine.replaceAll("]]>", "]]&amp;"));
                }
            } else {
                this.writer.write("\n");
                this.serializePrettyXml(tagChildren, level, dontEscape);
            }
            if (singleLine == null) {
                this.writer.write(indent);
            }
            this.serializeEndTag(tagNode);
        }
    }
}

