/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.conditions;

import com.nokia.helium.core.ant.types.ConditionType;
import com.nokia.helium.jpa.ORMReader;
import com.nokia.helium.jpa.entity.metadata.Metadata;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class MetaDataLogCondition
extends ConditionType {
    private String severity;
    private String logFile;
    private File fileName;

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setDb(File file) {
        this.fileName = file;
    }

    public void setLog(String log) {
        this.logFile = log;
    }

    public int getSeverity() {
        if (this.fileName == null || !this.fileName.exists() || this.logFile == null) {
            return -1;
        }
        if (this.severity == null) {
            throw new BuildException("'severity' attribute is not defined");
        }
        Metadata.PriorityEnum prty = null;
        if (this.severity.equalsIgnoreCase("ERROR")) {
            prty = Metadata.PriorityEnum.ERROR;
        } else if (this.severity.equalsIgnoreCase("WARNING")) {
            prty = Metadata.PriorityEnum.WARNING;
        } else if (this.severity.equalsIgnoreCase("FATAL")) {
            prty = Metadata.PriorityEnum.FATAL;
        } else if (this.severity.equalsIgnoreCase("INFO")) {
            prty = Metadata.PriorityEnum.INFO;
        } else if (this.severity.equalsIgnoreCase("REMARK")) {
            prty = Metadata.PriorityEnum.REMARK;
        } else {
            throw new BuildException("'severity' attribute is not valid");
        }
        String query = "select Count(m.id) from MetadataEntry m JOIN  m.logFile  as l JOIN m.priority as p where l.path like '%" + this.logFile + "' and UPPER(p.priority) like '%" + this.severity.toUpperCase() + "'";
        Number number = (Number)new ORMReader(this.fileName.getAbsolutePath()).executeSingleResult(query, null);
        return number.intValue();
    }

    public boolean eval() {
        int severity = this.getSeverity();
        if (severity < 0) {
            return false;
        }
        return severity > 0;
    }
}

