/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.FMParser;
import freemarker.core.FMParserTokenManager;
import freemarker.core.NonNumericalException;
import freemarker.core.ParseException;
import freemarker.core.SimpleCharStream;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.utility.StringUtil;
import java.io.StringReader;
import java.util.List;
import java.util.StringTokenizer;

abstract class StringBuiltins {
    StringBuiltins() {
    }

    static class substringBI
    extends StringBuiltIn {
        substringBI() {
        }

        TemplateModel calculateResult(final String s, Environment env) throws TemplateException {
            return new TemplateMethodModelEx(){

                public Object exec(List args) throws TemplateModelException {
                    int argCount = args.size();
                    int left = 0;
                    int right = 0;
                    if (argCount != 1 && argCount != 2) {
                        throw new TemplateModelException("Error: +getStartLocation() + \nExpecting 1 or 2 numerical arguments here");
                    }
                    try {
                        TemplateNumberModel tnm = (TemplateNumberModel)args.get(0);
                        left = tnm.getAsNumber().intValue();
                        if (argCount == 2) {
                            tnm = (TemplateNumberModel)args.get(1);
                            right = tnm.getAsNumber().intValue();
                        }
                    }
                    catch (ClassCastException cce) {
                        String mess = "Error: " + substringBI.this.getStartLocation() + "\nExpecting numerical argument here";
                        throw new TemplateModelException(mess);
                    }
                    if (argCount == 1) {
                        return new SimpleScalar(s.substring(left));
                    }
                    return new SimpleScalar(s.substring(left, right));
                }
            };
        }
    }

    static class numberBI
    extends StringBuiltIn {
        numberBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            try {
                return new SimpleNumber(env.getArithmeticEngine().toNumber(s));
            }
            catch (NumberFormatException nfe) {
                String mess = "Error: " + this.getStartLocation() + "\nExpecting a number here, found: " + s;
                throw new NonNumericalException(mess, env);
            }
        }
    }

    static class evalBI
    extends StringBuiltIn {
        evalBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            SimpleCharStream scs = new SimpleCharStream(new StringReader("(" + s + ")"), this.target.beginLine, this.target.beginColumn, s.length() + 2);
            FMParserTokenManager token_source = new FMParserTokenManager(scs);
            token_source.SwitchTo(2);
            FMParser parser = new FMParser(token_source);
            parser.template = this.getTemplate();
            Expression exp = null;
            try {
                exp = parser.Expression();
            }
            catch (ParseException pe) {
                pe.setTemplateName(this.getTemplate().getName());
                throw new TemplateException(pe, env);
            }
            return exp.getAsTemplateModel(env);
        }
    }

    static class word_listBI
    extends StringBuiltIn {
        word_listBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            SimpleSequence result = new SimpleSequence();
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
            return result;
        }
    }

    static class lower_caseBI
    extends StringBuiltIn {
        lower_caseBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(s.toLowerCase(env.getLocale()));
        }
    }

    static class upper_caseBI
    extends StringBuiltIn {
        upper_caseBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(s.toUpperCase(env.getLocale()));
        }
    }

    static class uncap_firstBI
    extends StringBuiltIn {
        uncap_firstBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            int i;
            int ln = s.length();
            for (i = 0; i < ln && Character.isWhitespace(s.charAt(i)); ++i) {
            }
            if (i < ln) {
                StringBuffer b = new StringBuffer(s);
                b.setCharAt(i, Character.toLowerCase(s.charAt(i)));
                s = b.toString();
            }
            return new SimpleScalar(s);
        }
    }

    static class cap_firstBI
    extends StringBuiltIn {
        cap_firstBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            int i;
            int ln = s.length();
            for (i = 0; i < ln && Character.isWhitespace(s.charAt(i)); ++i) {
            }
            if (i < ln) {
                StringBuffer b = new StringBuffer(s);
                b.setCharAt(i, Character.toUpperCase(s.charAt(i)));
                s = b.toString();
            }
            return new SimpleScalar(s);
        }
    }

    static class js_stringBI
    extends StringBuiltIn {
        js_stringBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.javaScriptStringEnc(s));
        }
    }

    static class j_stringBI
    extends StringBuiltIn {
        j_stringBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.javaStringEnc(s));
        }
    }

    static class chop_linebreakBI
    extends StringBuiltIn {
        chop_linebreakBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.chomp(s));
        }
    }

    static class capitalizeBI
    extends StringBuiltIn {
        capitalizeBI() {
        }

        TemplateModel calculateResult(String s, Environment env) {
            return new SimpleScalar(StringUtil.capitalize(s));
        }
    }

    static abstract class StringBuiltIn
    extends BuiltIn {
        StringBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            return this.calculateResult(this.target.getStringValue(env), env);
        }

        abstract TemplateModel calculateResult(String var1, Environment var2) throws TemplateException;
    }
}

