/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antunit.ant.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.ant.antunit.AntUnitListener;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;

public class CustomListener
extends DataType
implements AntUnitListener {
    private Project currentProject;
    private List<Listener> listenerDefinitions = new ArrayList<Listener>();
    private List<BuildListener> listeners = new ArrayList<BuildListener>();

    public Listener createListener() {
        Listener listener = new Listener();
        this.listenerDefinitions.add(listener);
        return listener;
    }

    public void addError(String name, Throwable error) {
    }

    public void addFailure(String name, AssertionFailedException exception) {
    }

    public void endTest(String name) {
        for (BuildListener bl : this.listeners) {
            this.currentProject.removeBuildListener(bl);
            bl.buildFinished(new BuildEvent(this.currentProject));
        }
    }

    public void endTestSuite(Project project, String name) {
    }

    public void setCurrentTestProject(Project project) {
        this.currentProject = project;
    }

    public void setParentTask(Task task) {
    }

    public void startTest(String name) {
        this.listeners.clear();
        for (Listener l : this.listenerDefinitions) {
            BuildListener bl = l.instantiate();
            l.setProject(this.currentProject);
            if (bl == null) continue;
            this.listeners.add(bl);
            bl.buildStarted(new BuildEvent(this.currentProject));
            this.currentProject.addBuildListener(bl);
        }
    }

    public void startTestSuite(Project project, String name) {
    }

    public class Listener
    extends DataType {
        private String className;

        public void setClassname(String className) {
            this.className = className;
        }

        public BuildListener instantiate() {
            if (this.className != null) {
                try {
                    Class<?> clazz = Class.forName(this.className);
                    return (BuildListener)clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    this.log("ERROR: " + e.toString(), 0);
                }
                catch (InstantiationException e) {
                    this.log("ERROR: " + e.toString(), 0);
                }
                catch (IllegalAccessException e) {
                    this.log("ERROR: " + e.toString(), 0);
                }
            }
            return null;
        }
    }
}

