/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.sbs;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.SAXReader;

public class SAXSysdefParser {
    private File sysdefFile;
    private String configs = "";
    private List<String> layers;
    private boolean initialized;
    private Logger log = Logger.getLogger(SAXSysdefParser.class);

    public SAXSysdefParser(File fileName) {
        this.sysdefFile = fileName;
    }

    public List<String> getLayers() {
        if (!this.initialized) {
            this.initialized = true;
            this.parseConfig("layer");
            if (this.layers == null) {
                throw new BuildException("No layers found from sysdef");
            }
        }
        return this.layers;
    }

    public void parseConfig(String nodeToGet) {
        this.layers = new ArrayList<String>();
        SAXReader reader = new SAXReader();
        reader.addHandler("/SystemDefinition/systemModel/" + nodeToGet, new ElementHandler(){

            public void onStart(ElementPath path) {
            }

            public void onEnd(ElementPath path) {
                Element row = path.getCurrent();
                Iterator itr = row.attributeIterator();
                while (itr.hasNext()) {
                    Attribute child = (Attribute)itr.next();
                    String attrName = child.getQualifiedName();
                    if (!attrName.equals("name")) continue;
                    SAXSysdefParser.this.layers.add(child.getValue());
                }
                row.detach();
            }
        });
        try {
            Document doc = reader.read(this.sysdefFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

