/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data;

import com.nokia.helium.ant.data.AntFile;
import com.nokia.helium.ant.data.AntObjectMeta;
import com.nokia.helium.ant.data.MacroMeta;
import com.nokia.helium.ant.data.PropertyCommentMeta;
import com.nokia.helium.ant.data.PropertyMeta;
import com.nokia.helium.ant.data.RootAntObjectMeta;
import com.nokia.helium.ant.data.TargetMeta;
import java.io.File;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Comment;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ProjectMeta
extends RootAntObjectMeta {
    private static final String DOC_COMMENT_MARKER = "*";
    private String description = "";

    public ProjectMeta(AntFile antFile, Element node) throws DocumentException, IOException {
        super(antFile, node);
        Element descriptionNode;
        if (!this.getComment().isMarkedComment()) {
            this.setComment(this.getEmptyComment());
        }
        if ((descriptionNode = ((Element)this.getNode()).element("description")) != null) {
            this.description = descriptionNode.getStringValue().trim();
        }
    }

    @Override
    public File getFile() {
        return this.getAntFile().getFile();
    }

    public String getDefault() {
        return this.getAttr("default");
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPackage() {
        return this.getComment().getTagValue("package", "(default)");
    }

    @Override
    public String getSummary() {
        String text = this.getDescription();
        if (text.length() == 0) {
            text = this.getDocumentation();
        }
        BreakIterator iterator = BreakIterator.getSentenceInstance();
        iterator.setText(text);
        String summary = "";
        if (iterator.next() > 0) {
            summary = text.substring(0, iterator.current()).trim();
        }
        return summary;
    }

    public List<TargetMeta> getTargets() throws IOException {
        ArrayList<TargetMeta> objects = new ArrayList<TargetMeta>();
        List nodes = this.getNode().selectNodes("target");
        for (Node targetNode : nodes) {
            TargetMeta targetMeta = new TargetMeta(this, targetNode);
            targetMeta.setRuntimeProject(this.getRuntimeProject());
            if (!targetMeta.matchesScope(this.getScopeFilter())) continue;
            objects.add(targetMeta);
        }
        return objects;
    }

    public List<PropertyMeta> getProperties() throws IOException {
        ArrayList<PropertyMeta> properties = new ArrayList<PropertyMeta>();
        List propertyNodes = this.getNode().selectNodes("//property");
        for (Node propNode : propertyNodes) {
            PropertyMeta propertyMeta = new PropertyMeta(this, propNode);
            propertyMeta.setRuntimeProject(this.getRuntimeProject());
            if (!propertyMeta.matchesScope(this.getScopeFilter())) continue;
            properties.add(propertyMeta);
        }
        return properties;
    }

    @Override
    public List<MacroMeta> getMacros() throws IOException {
        ArrayList<MacroMeta> objects = new ArrayList<MacroMeta>();
        List nodes = this.getNode().selectNodes("//macrodef | //scriptdef");
        for (Element node : nodes) {
            MacroMeta macroMeta = new MacroMeta((AntObjectMeta)this, node);
            macroMeta.setRuntimeProject(this.getRuntimeProject());
            if (!macroMeta.matchesScope(this.getScopeFilter())) continue;
            objects.add(macroMeta);
        }
        return objects;
    }

    public List<String> getProjectDependencies() {
        ArrayList<String> objects = new ArrayList<String>();
        List importNodes = this.getNode().selectNodes("//import");
        for (Element node : importNodes) {
            objects.add(node.attributeValue("file"));
        }
        return objects;
    }

    public List<String> getLibraryDependencies() {
        ArrayList<String> objects = new ArrayList<String>();
        List nodes = this.getNode().selectNodes("//typedef");
        for (Element node : nodes) {
            if (node.attributeValue("file") != null) {
                objects.add(node.attributeValue("file"));
                continue;
            }
            if (node.attributeValue("resource") == null) continue;
            objects.add(node.attributeValue("resource"));
        }
        return objects;
    }

    public List<PropertyCommentMeta> getPropertyCommentBlocks() throws IOException {
        ArrayList<PropertyCommentMeta> objects = new ArrayList<PropertyCommentMeta>();
        List nodes = this.getNode().selectNodes("//comment()");
        for (Node node : nodes) {
            String text = node.getText().trim();
            if (!text.startsWith("* @property")) continue;
            PropertyCommentMeta propertyCommentMeta = new PropertyCommentMeta((AntObjectMeta)this, (Comment)node);
            propertyCommentMeta.setRuntimeProject(this.getRuntimeProject());
            objects.add(propertyCommentMeta);
        }
        return objects;
    }
}

