/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.iapi.types.Resetable;

public class PositionedStoreStream
extends InputStream
implements PositionedStream,
Resetable {
    private final InputStream stream;
    private long pos = 0L;

    public PositionedStoreStream(InputStream inputStream) throws IOException, StandardException {
        this.stream = inputStream;
        ((Resetable)((Object)inputStream)).initStream();
        ((Resetable)((Object)inputStream)).resetStream();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.stream.read(byArray, n, n2);
        if (n3 > -1) {
            this.pos += (long)n3;
        }
        return n3;
    }

    public int read() throws IOException {
        int n = this.stream.read();
        if (n > -1) {
            ++this.pos;
        }
        return n;
    }

    public long skip(long l) throws IOException {
        long l2 = this.stream.skip(l);
        this.pos += l2;
        return l2;
    }

    public void resetStream() throws IOException, StandardException {
        ((Resetable)((Object)this.stream)).resetStream();
        this.pos = 0L;
    }

    public void initStream() throws StandardException {
        ((Resetable)((Object)this.stream)).initStream();
    }

    public void closeStream() {
        ((Resetable)((Object)this.stream)).closeStream();
    }

    public void reposition(long l) throws IOException, StandardException {
        if (this.pos > l) {
            this.resetStream();
        }
        if (this.pos < l) {
            try {
                InputStreamUtil.skipFully(this.stream, l - this.pos);
            }
            catch (EOFException eOFException) {
                this.resetStream();
                throw eOFException;
            }
            this.pos = l;
        }
    }

    public long getPosition() {
        return this.pos;
    }

    public InputStream asInputStream() {
        return this;
    }
}

