/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.many;

import java.lang.reflect.Array;
import java.util.Collection;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class JAXBObjectArrayAttributeAccessor
extends AttributeAccessor {
    private AttributeAccessor nestedAccessor;
    private ContainerPolicy containerPolicy;
    private String componentClassName;
    private Class componentClass;

    public JAXBObjectArrayAttributeAccessor(AttributeAccessor nestedAccessor, ContainerPolicy containerPolicy) {
        this.nestedAccessor = nestedAccessor;
        this.containerPolicy = containerPolicy;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object value = this.nestedAccessor.getAttributeValueFromObject(object);
        if (value == null) {
            return null;
        }
        Object[] objects = (Object[])value;
        int length = objects.length;
        Object results = this.containerPolicy.containerInstance(length);
        for (int i = 0; i < length; ++i) {
            this.containerPolicy.addInto(objects[i], results, null);
        }
        return results;
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        Collection collectionValue = (Collection)value;
        Object[] myArray = (Object[])Array.newInstance(this.getComponentClass(), collectionValue.size());
        this.nestedAccessor.setAttributeValueInObject(object, collectionValue.toArray(myArray));
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(theJavaClass);
        if (this.componentClass == null && this.componentClassName != null) {
            this.componentClass = ConversionManager.getDefaultManager().convertClassNameToClass(this.getComponentClassName());
        }
    }

    public Class getComponentClass() {
        return this.componentClass;
    }

    public void setComponentClass(Class componentClass) {
        this.componentClass = componentClass;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public void setComponentClassName(String componentClassName) {
        this.componentClassName = componentClassName;
    }
}

