/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;

public class HeliumLogger
extends DefaultLogger {
    private static boolean stopLogToConsole;
    private Date endOfPreviousTarget;
    private Project project;
    private Log log = LogFactory.getLog(HeliumLogger.class);
    private boolean isInitialized;
    private String directory;
    private SimpleDateFormat timeFormat;
    private Date buildStartTime;
    private Date buildEndTime;
    private Date targetStartTime;
    private ArrayList<String> targetTable;
    private Hashtable tempStartTime;
    private StringBuffer allStages;

    public void buildStarted(BuildEvent event) {
        this.project = event.getProject();
        this.endOfPreviousTarget = new Date();
        this.buildStartTime = new Date();
        this.endOfPreviousTarget = new Date();
        this.targetTable = new ArrayList();
        this.tempStartTime = new Hashtable();
        this.allStages = new StringBuffer("\t<stages>");
        super.buildStarted(event);
    }

    public void targetStarted(BuildEvent event) {
        String targetName = event.getTarget().getName();
        this.targetStartTime = new Date();
        this.logTargetEvent(targetName, "start");
        if (!this.isInitialized) {
            this.initializeLogger();
        }
        if (this.isInitialized) {
            this.tempStartTime.put(targetName, new Date());
        }
        super.targetStarted(event);
    }

    private void initializeLogger() {
        this.directory = this.project.getProperty("build.log.dir");
        this.isInitialized = true;
    }

    private void logTargetEvent(String targetName, String event) {
        String logTargetProperty = this.project.getProperty("log.target");
        if (logTargetProperty != null && logTargetProperty.equals("yes")) {
            this.log.info((Object)("Target #### " + targetName + " ####: " + event));
        }
    }

    public void targetFinished(BuildEvent event) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = sdf.format(Calendar.getInstance().getTime());
        String targetName = time + "," + event.getTarget().getName();
        this.logTargetEvent(targetName, "finish");
        this.logTargetTime(targetName);
    }

    private void logTargetTime(String targetName) {
        Date targetFinishTime = new Date();
        long targetLengthMSecs = targetFinishTime.getTime() - this.targetStartTime.getTime();
        Long outputSecs = TimeUnit.MILLISECONDS.toSeconds(targetLengthMSecs);
        this.targetTable.add(targetName + "," + outputSecs.toString());
    }

    public void buildFinished(BuildEvent event) {
        if (this.isInitialized) {
            if (this.directory != null && new File(this.directory).exists()) {
                try {
                    String timesLogFileName = this.directory + File.separator + this.project.getProperty("build.id") + "_targetTimesLog.csv";
                    File timesLogFile = new File(timesLogFileName);
                    FileOutputStream timesLogFileStream = new FileOutputStream(timesLogFileName, true);
                    DataOutputStream timesLogOut = new DataOutputStream(timesLogFileStream);
                    for (String s : this.targetTable) {
                        timesLogOut.writeBytes(s + "\n");
                    }
                    timesLogOut.close();
                }
                catch (Exception ex) {
                    this.log.fatal((Object)"Exception has occurred", (Throwable)ex);
                    ex.printStackTrace();
                }
            }
            this.cleanup();
        }
        super.buildFinished(event);
    }

    private void cleanup() {
        File f;
        String loggingoutputfile = this.project.getProperty("logging.output.file");
        if (loggingoutputfile != null && (f = new File(loggingoutputfile)).exists()) {
            f.delete();
        }
        if (this.project.getProperty("call.cleanup") != null && this.project.getProperty("call.cleanup").equals("yes")) {
            this.project.executeTarget("cleanup-all");
        }
    }

    public static boolean getStopLogToConsole() {
        return stopLogToConsole;
    }

    public static void setStopLogToConsole(boolean stop) {
        stopLogToConsole = stop;
    }

    protected void printMessage(String message, PrintStream stream, int priority) {
        if (!stopLogToConsole) {
            stream.println(message);
        }
    }
}

