/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Arrays;

public class MagicNumberCheck
extends Check {
    private static final int[] ALLOWED_PATH_TOKENTYPES = new int[]{80, 29, 28, 32, 31, 23, 34, 136, 27, 60};
    private double[] mIgnoreNumbers = new double[]{-1.0, 0.0, 1.0, 2.0};

    public int[] getDefaultTokens() {
        return new int[]{142, 140, 137, 141};
    }

    public void visitToken(DetailAST aAST) {
        if (this.inIgnoreList(aAST)) {
            return;
        }
        DetailAST constantDefAST = this.findContainingConstantDef(aAST);
        if (constantDefAST == null) {
            this.reportMagicNumber(aAST);
        } else {
            for (DetailAST ast = aAST.getParent(); ast != constantDefAST; ast = ast.getParent()) {
                int type = ast.getType();
                if (Arrays.binarySearch(ALLOWED_PATH_TOKENTYPES, type) >= 0) continue;
                this.reportMagicNumber(aAST);
                break;
            }
        }
    }

    private DetailAST findContainingConstantDef(DetailAST aAST) {
        DetailAST varDefAST;
        for (varDefAST = aAST; varDefAST != null && varDefAST.getType() != 10 && varDefAST.getType() != 155; varDefAST = varDefAST.getParent()) {
        }
        if (varDefAST == null) {
            return null;
        }
        if (ScopeUtils.inInterfaceOrAnnotationBlock(varDefAST) || varDefAST.getType() == 155) {
            return varDefAST;
        }
        DetailAST modifiersAST = varDefAST.findFirstToken(5);
        if (modifiersAST.branchContains(39)) {
            return varDefAST;
        }
        return null;
    }

    private void reportMagicNumber(DetailAST aAST) {
        String text = aAST.getText();
        DetailAST parent = aAST.getParent();
        DetailAST reportAST = aAST;
        if (parent.getType() == 31) {
            reportAST = parent;
            text = "-" + text;
        } else if (parent.getType() == 32) {
            reportAST = parent;
            text = "+" + text;
        }
        this.log(reportAST.getLineNo(), reportAST.getColumnNo(), "magic.number", text);
    }

    private boolean inIgnoreList(DetailAST aAST) {
        double value = CheckUtils.parseDouble(aAST.getText(), aAST.getType());
        DetailAST parent = aAST.getParent();
        if (parent.getType() == 31) {
            value = -1.0 * value;
        }
        return Arrays.binarySearch(this.mIgnoreNumbers, value) >= 0;
    }

    public void setIgnoreNumbers(double[] aList) {
        if (aList == null || aList.length == 0) {
            this.mIgnoreNumbers = new double[0];
        } else {
            this.mIgnoreNumbers = new double[aList.length];
            System.arraycopy(aList, 0, this.mIgnoreNumbers, 0, aList.length);
            Arrays.sort(this.mIgnoreNumbers);
        }
    }

    static {
        Arrays.sort(ALLOWED_PATH_TOKENTYPES);
    }
}

