/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.WaitError;
import org.apache.derby.impl.store.access.btree.index.B2I;

class B2IRowLocking3
implements BTreeLockingPolicy {
    protected ConglomerateController base_cc;
    protected OpenBTree open_btree;
    private Transaction rawtran;

    B2IRowLocking3(Transaction transaction, int n, LockingPolicy lockingPolicy, ConglomerateController conglomerateController, OpenBTree openBTree) {
        this.rawtran = transaction;
        this.base_cc = conglomerateController;
        this.open_btree = openBTree;
    }

    private boolean lockPreviousToFirstKey(LeafControlRow leafControlRow, LeafControlRow leafControlRow2, int n, int n2) throws StandardException {
        boolean bl = this.base_cc.lockRow(1L, 3, n, false, n2);
        if (!bl) {
            leafControlRow.release();
            leafControlRow = null;
            if (leafControlRow2 != null) {
                leafControlRow2.release();
                leafControlRow2 = null;
            }
            this.base_cc.lockRow(1L, 3, n, true, n2);
        }
        return bl;
    }

    private boolean lockRowOnPage(BTree bTree, LeafControlRow leafControlRow, LeafControlRow leafControlRow2, int n, BTreeRowPosition bTreeRowPosition, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, int n2, int n3) throws StandardException {
        RecordHandle recordHandle = leafControlRow.getPage().fetchFromSlot(null, n, dataValueDescriptorArray, fetchDescriptor, true);
        boolean bl = this.base_cc.lockRow(rowLocation, n2, false, n3);
        if (!bl) {
            if (bTreeRowPosition != null) {
                bTreeRowPosition.saveMeAndReleasePage();
            } else if (leafControlRow != null) {
                leafControlRow.release();
                leafControlRow = null;
            }
            if (leafControlRow2 != null) {
                leafControlRow2.release();
                leafControlRow2 = null;
            }
            this.base_cc.lockRow(rowLocation, n2, true, n3);
        }
        return bl;
    }

    private boolean searchLeftAndLockPreviousKey(B2I b2I, LeafControlRow leafControlRow, int n, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, OpenBTree openBTree, int n2, int n3) throws StandardException {
        long l;
        LeafControlRow leafControlRow2;
        boolean bl = false;
        try {
            leafControlRow2 = (LeafControlRow)leafControlRow.getLeftSibling(openBTree);
        }
        catch (WaitError waitError) {
            l = leafControlRow.getleftSiblingPageNumber();
            leafControlRow.release();
            leafControlRow = null;
            leafControlRow2 = (LeafControlRow)ControlRow.get(openBTree, l);
            bl = true;
        }
        block4: while (true) {
            try {
                while (true) {
                    if (leafControlRow2.getPage().recordCount() > 1) {
                        boolean bl2 = this.lockRowOnPage(b2I, leafControlRow2, leafControlRow, leafControlRow2.getPage().recordCount() - 1, null, fetchDescriptor, dataValueDescriptorArray, rowLocation, n2, n3);
                        if (bl2) break block4;
                        leafControlRow2 = null;
                        leafControlRow = null;
                        bl = true;
                        break block4;
                    }
                    if (leafControlRow2.isLeftmostLeaf()) {
                        boolean bl3 = this.lockPreviousToFirstKey(leafControlRow2, leafControlRow, n2, n3);
                        if (bl3) break block4;
                        leafControlRow2 = null;
                        leafControlRow = null;
                        bl = true;
                        break block4;
                    }
                    LeafControlRow leafControlRow3 = (LeafControlRow)leafControlRow2.getLeftSibling(openBTree);
                    leafControlRow2.release();
                    leafControlRow2 = leafControlRow3;
                    leafControlRow3 = null;
                }
            }
            catch (WaitError waitError) {
                l = leafControlRow2.getleftSiblingPageNumber();
                if (leafControlRow != null) {
                    leafControlRow.release();
                    leafControlRow = null;
                }
                leafControlRow2.release();
                leafControlRow2 = null;
                leafControlRow2 = (LeafControlRow)ControlRow.get(openBTree, l);
                bl = true;
                continue;
            }
            break;
        }
        if (leafControlRow2 != null) {
            leafControlRow2.release();
        }
        return !bl;
    }

    protected boolean _lockScanRow(OpenBTree openBTree, BTree bTree, BTreeRowPosition bTreeRowPosition, boolean bl, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, boolean bl2, boolean bl3, int n) throws StandardException {
        boolean bl4 = false;
        B2I b2I = (B2I)bTree;
        if (bl) {
            bl4 = bTreeRowPosition.current_slot == 0 ? !this.lockNonScanPreviousRow(bTree, bTreeRowPosition.current_leaf, 1, fetchDescriptor, dataValueDescriptorArray, rowLocation, openBTree, n, 2) : !this.lockRowOnPage(bTree, bTreeRowPosition.current_leaf, null, bTreeRowPosition.current_slot, bTreeRowPosition, fetchDescriptor, dataValueDescriptorArray, rowLocation, n, 2);
        }
        return !bl4;
    }

    public boolean lockScanCommittedDeletedRow(OpenBTree openBTree, LeafControlRow leafControlRow, DataValueDescriptor[] dataValueDescriptorArray, FetchDescriptor fetchDescriptor, int n) throws StandardException {
        RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[((B2I)openBTree.getConglomerate()).rowLocationColumn];
        leafControlRow.getPage().fetchFromSlot(null, n, dataValueDescriptorArray, fetchDescriptor, true);
        return this.base_cc.lockRow(rowLocation, 1, false, 2);
    }

    public boolean lockScanRow(OpenBTree openBTree, BTree bTree, BTreeRowPosition bTreeRowPosition, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, boolean bl, boolean bl2, int n) throws StandardException {
        return this._lockScanRow(openBTree, bTree, bTreeRowPosition, true, fetchDescriptor, dataValueDescriptorArray, rowLocation, bl, bl2, n);
    }

    public void unlockScanRecordAfterRead(BTreeRowPosition bTreeRowPosition, boolean bl) throws StandardException {
    }

    public boolean lockNonScanPreviousRow(BTree bTree, LeafControlRow leafControlRow, int n, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, OpenBTree openBTree, int n2, int n3) throws StandardException {
        boolean bl = n > 1 ? this.lockRowOnPage(bTree, leafControlRow, null, n - 1, null, fetchDescriptor, dataValueDescriptorArray, rowLocation, n2, n3) : (leafControlRow.isLeftmostLeaf() ? this.lockPreviousToFirstKey(leafControlRow, null, n2, n3) : this.searchLeftAndLockPreviousKey((B2I)bTree, leafControlRow, n, fetchDescriptor, dataValueDescriptorArray, rowLocation, openBTree, n2, n3));
        return bl;
    }

    public boolean lockNonScanRow(BTree bTree, LeafControlRow leafControlRow, LeafControlRow leafControlRow2, DataValueDescriptor[] dataValueDescriptorArray, int n) throws StandardException {
        B2I b2I = (B2I)bTree;
        boolean bl = this.base_cc.lockRow((RowLocation)dataValueDescriptorArray[b2I.rowLocationColumn], n, false, 2);
        if (!bl) {
            if (leafControlRow != null) {
                leafControlRow.release();
                leafControlRow = null;
            }
            if (leafControlRow2 != null) {
                leafControlRow2.release();
                leafControlRow2 = null;
            }
            this.base_cc.lockRow((RowLocation)dataValueDescriptorArray[b2I.rowLocationColumn], n, true, 2);
        }
        return bl;
    }

    public boolean lockNonScanRowOnPage(BTree bTree, LeafControlRow leafControlRow, int n, FetchDescriptor fetchDescriptor, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, int n2) throws StandardException {
        return this.lockRowOnPage(bTree, leafControlRow, null, n, null, fetchDescriptor, dataValueDescriptorArray, rowLocation, n2, 2);
    }
}

