/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class NestedTable
extends DatabaseTable {
    private QueryKeyExpression queryKeyExpression;

    public NestedTable() {
    }

    public NestedTable(QueryKeyExpression queryKeyExpression) {
        this.queryKeyExpression = queryKeyExpression;
        this.setName(queryKeyExpression.getMapping().getDescriptor().getTables().firstElement().getName());
        this.tableQualifier = queryKeyExpression.getMapping().getDescriptor().getTables().firstElement().getQualifiedName();
    }

    public String getQualifiedName(DatasourcePlatform platform) {
        return this.getQualifiedName(platform, false);
    }

    public String getQualifiedNameDelimited(DatasourcePlatform platform) {
        return this.getQualifiedName(platform, true);
    }

    private String getQualifiedName(DatasourcePlatform platform, boolean allowDelimiters) {
        if (this.qualifiedName == null) {
            DatabaseMapping mapping = this.queryKeyExpression.getMapping();
            DatabaseTable nestedTable = mapping.getDescriptor().getTables().firstElement();
            DatabaseTable tableAlias = this.queryKeyExpression.getBaseExpression().aliasForTable(nestedTable);
            DatabaseTable nestedTableAlias = this.queryKeyExpression.aliasForTable(this);
            StringBuffer name = new StringBuffer();
            name.append("TABLE(");
            if (allowDelimiters && this.useDelimiters) {
                name.append(platform.getStartDelimiter());
            }
            name.append(tableAlias.getName());
            if (allowDelimiters && this.useDelimiters) {
                name.append(platform.getEndDelimiter());
            }
            name.append(".");
            if (allowDelimiters && this.useDelimiters) {
                name.append(platform.getStartDelimiter());
            }
            name.append(mapping.getField().getNameDelimited(platform));
            if (allowDelimiters && this.useDelimiters) {
                name.append(platform.getEndDelimiter());
            }
            name.append(")");
            this.qualifiedName = name.toString();
        }
        return this.qualifiedName;
    }

    public QueryKeyExpression getQuerykeyExpression() {
        return this.queryKeyExpression;
    }

    public void setQuerykeyExpression(QueryKeyExpression queryKeyExpression) {
        this.queryKeyExpression = queryKeyExpression;
    }
}

