#include "cvs.h"

/* lstat */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

/* ctime */
#include <time.h>

/*strdup */
#include <string.h>

/* dirname */
#include <libgen.h>

/* fopen */
#include <stdio.h>

/* regcomp regexec */
#include <regex.h>

#include "make.h"

typedef struct _cvs_entry {
  struct _cvs_entry *next;
  char * filename;
  char * version;
  char * timestamp;
}cvs_entry;

typedef struct _cvs_entries_file {
  struct _cvs_entries_file *next;
  cvs_entry * entry;
  char *filepath;
}cvs_entries_file;

cvs_entries_file *cvs_entries = NULL;

regex_t reg_file;
int reg_init = 0;

int cvs_clean_cache(){
cvs_entries_file *f;
cvs_entry *e;

  for (f = cvs_entries;f;f = cvs_entries) {
    cvs_entries = f->next;
    for (e = f->entry;e;e = f->entry) {
      f->entry = e->next;
      free (e->filename);
      free (e->version);
      free (e->timestamp);
      free (e);
    }
    free(f->filepath);
    free (f);
  }
}


cvs_entries_file *read_entries_file(char * filepath) {
  cvs_entries_file *c;
  FILE *fd_entries;
  
  
  if (reg_init == 0) {
    regcomp(&reg_file,"^/([^/]*)/([^/]*)/([^/]*)/[^/]*/",REG_EXTENDED);
    reg_init = 1;
  }

 
  
  for ( c = cvs_entries ; c ; c = c->next )
    if (!strcmp(filepath,c->filepath))
      return c;
  printf("READ %s\n",filepath);

     
  fd_entries = fopen(filepath,"r");
  
  if (  fd_entries == NULL) return NULL;
      
  c = (cvs_entries_file *) xmalloc(sizeof(cvs_entries_file));
  
  c->filepath = strdup(filepath);
  c->entry = NULL;
  
  while(!feof(fd_entries)) {
    regmatch_t match[4];
    char buffer[256];
    
    fgets(buffer,250,fd_entries);
        
    if (regexec(&reg_file,buffer,4,match,0) == 0) {
      cvs_entry *e = (cvs_entry*) xmalloc(sizeof(cvs_entry));
      buffer[match[1].rm_eo] = 0; /* filename */
      buffer[match[2].rm_eo] = 0; /* version */
      buffer[match[3].rm_eo] = 0; /* timestamp */
	
      e->filename  = strdup(&buffer[match[1].rm_so]);
      e->version   = strdup(&buffer[match[2].rm_so]);
      e->timestamp = strdup(&buffer[match[3].rm_so]);
            
      e->next = c->entry;
      c->entry = e;
    }
  }

  fclose(fd_entries);
  
  c->next = cvs_entries;
  cvs_entries = c;
  return c;
}


int cvs_get_workdate(char *file_name,char *date){
  struct stat buf;
  if (lstat(file_name,&buf ) == 0) {
    char *s = asctime(gmtime(&buf.st_mtime));
    s[strlen(s)-1] = 0;
    strcpy (date,s);
    return 1;
  }
  return 0;
}

int cvs_get_cvsinfo(char *filename,char *date,char *version){
  int ret = 0;
  char *dir_buf = strdup (filename);
  char *base_buf = strdup (filename);
  
  char *dir = dirname(dir_buf);
  char *base = basename(base_buf);

  char Entries_path[256];
  cvs_entries_file *c;
  
  sprintf(Entries_path,"%s/CVS/Entries",dir);
  
  c = read_entries_file(Entries_path);
  
  if (c != NULL) {
    cvs_entry *e; 
    for (e= c-> entry;e;e=e->next)
      if( !strcmp(filename,e->filename) ) {
          strcpy(version,e->version);
          strcpy(date,e->timestamp);
	  ret = 1;
	  break;
      }
  }
  
  free ( dir_buf );
  free ( base_buf );

  return (ret);
}

