/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.ActionComponent;
import com.sardak.antform.interfaces.Focusable;
import com.sardak.antform.types.BaseType;
import com.sardak.antform.util.ActionType;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.apache.tools.ant.Task;

public class Button
extends BaseType
implements ActionComponent,
Focusable {
    private String target;
    private boolean background = false;
    private JButton button = new JButton();
    private int type = 0;
    private boolean focus = false;
    private boolean loopExit = false;
    private boolean newProject = true;

    public boolean isNewProject() {
        return this.newProject;
    }

    public void setNewProject(boolean newProject) {
        this.newProject = newProject;
    }

    public Button() {
    }

    public Button(String text, String target, int actionType) {
        this.setLabel(text);
        this.setTarget(target);
        this.type = actionType;
    }

    public String getLabel() {
        return this.button.getText();
    }

    public void setLabel(String label) {
        this.button.setText(label);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTooltip() {
        return this.button.getToolTipText();
    }

    public void setTooltip(String tooltip) {
        if (tooltip != null) {
            this.button.setToolTipText(tooltip);
        }
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public int getActionType() {
        return this.type;
    }

    public void setType(ActionType type) {
        this.type = type.getType();
    }

    public boolean isLoopExit() {
        return this.loopExit;
    }

    public void setLoopExit(boolean loopExit) {
        this.loopExit = loopExit;
    }

    public AbstractButton getComponent() {
        return this.button;
    }

    public boolean validate(Task task) {
        boolean valid = true;
        if (this.getLabel() == null) {
            task.log("Button has no label");
            valid = false;
        }
        return valid;
    }

    public void addToControlPanel(ControlPanel panel) {
    }

    public String toString() {
        return super.toString() + " [label:" + this.getLabel() + ", type:" + ActionType.getType(this.getActionType()) + ", target:" + this.getTarget() + ", background:" + this.isBackground() + "]";
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public JComponent getFocusableComponent() {
        return this.button;
    }
}

