/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagNode
extends TagToken {
    public static final String[] ALLOWED_ATTRIBUTES = new String[]{"title", "align", "lang", "dir", "width", "height", "bgcolor", "clear", "noshade", "cite", "size", "face", "color", "type", "start", "value", "compact", "summary", "width", "border", "frame", "rules", "cellspacing", "cellpadding", "valign", "char", "charoff", "colgroup", "col", "span", "abbr", "axis", "headers", "scope", "rowspan", "colspan", "id", "class", "name", "href", "rel", "alt", "src"};
    protected static final HashSet<String> ALLOWED_ATTRIBUTES_SET = new HashSet();
    private TagNode parent = null;
    private Map<String, String> attributes = new TreeMap<String, String>();
    private HashMap<String, Object> objectAttributes = null;
    private List children = new ArrayList();
    private List itemsToMove = null;
    private transient boolean isFormed = false;

    static {
        int i = 0;
        while (i < ALLOWED_ATTRIBUTES.length) {
            ALLOWED_ATTRIBUTES_SET.add(ALLOWED_ATTRIBUTES[i]);
            ++i;
        }
    }

    public static Set<String> getAllowedAttributes() {
        return ALLOWED_ATTRIBUTES_SET;
    }

    public static boolean removeAllowedAttribute(String key) {
        return ALLOWED_ATTRIBUTES_SET.remove(key);
    }

    public static boolean addAllowedAttribute(String key) {
        return ALLOWED_ATTRIBUTES_SET.add(key);
    }

    public TagNode() {
    }

    public TagNode(String name) {
        super(name.toLowerCase());
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getObjectAttributes() {
        return this.objectAttributes;
    }

    public List getChildren() {
        return this.children;
    }

    public TagNode getParent() {
        return this.parent;
    }

    public void setParent(TagNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean addAttribute(String attName, String attValue, boolean checkXSS) {
        if (attName != null && !"".equals(attName.trim()) && attValue != null) {
            boolean checkedAttributes = true;
            String nameLowerCased = attName.toLowerCase();
            String valueLowerCased = attValue.toLowerCase();
            if (checkXSS && !TagNode.getAllowedAttributes().contains(nameLowerCased)) {
                checkedAttributes = false;
            }
            if (checkedAttributes && valueLowerCased.contains("javascript:")) {
                checkedAttributes = false;
            }
            if (checkedAttributes && attName.equalsIgnoreCase("style")) {
                if (valueLowerCased.contains("expression")) {
                    checkedAttributes = false;
                } else if (valueLowerCased.contains("url")) {
                    checkedAttributes = false;
                } else if (valueLowerCased.contains("tps")) {
                    checkedAttributes = false;
                }
            }
            if (checkedAttributes) {
                this.attributes.put(nameLowerCased, attValue);
                return true;
            }
        }
        return false;
    }

    public void addObjectAttribute(String attName, Object attValue) {
        if (attName != null && attValue != null) {
            if (this.objectAttributes == null) {
                this.objectAttributes = new HashMap(4);
            }
            this.objectAttributes.put(attName, attValue);
        }
    }

    public void addChild(Object child) {
        this.children.add(child);
        if (child instanceof TagNode) {
            TagNode childTagNode = (TagNode)child;
            childTagNode.parent = this;
        }
    }

    public void addChildren(List children) {
        if (children != null) {
            for (BaseToken child : children) {
                this.addChild(child);
            }
        }
    }

    public void addItemForMoving(Object item) {
        if (this.itemsToMove == null) {
            this.itemsToMove = new ArrayList();
        }
        this.itemsToMove.add(item);
    }

    public List getItemsToMove() {
        return this.itemsToMove;
    }

    public void setItemsToMove(List itemsToMove) {
        this.itemsToMove = itemsToMove;
    }

    public boolean isFormed() {
        return this.isFormed;
    }

    public void setFormed() {
        this.isFormed = true;
    }

    @Override
    public void serialize(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.serialize(this);
    }

    public TagNode makeCopy() {
        TagNode copy = new TagNode(this.name);
        copy.attributes = this.attributes;
        copy.objectAttributes = this.objectAttributes;
        return copy;
    }

    @Override
    public Object clone() {
        TagNode tt = (TagNode)super.clone();
        tt.parent = this.parent;
        tt.itemsToMove = this.itemsToMove;
        tt.isFormed = this.isFormed;
        tt.children = new ArrayList(this.children);
        tt.attributes = new TreeMap<String, String>(this.attributes);
        tt.objectAttributes = this.objectAttributes == null ? null : new HashMap<String, Object>(this.objectAttributes);
        return tt;
    }

    @Override
    public String getParents() {
        return null;
    }

    public String getBodyString() {
        List children = this.getChildren();
        if (children.size() == 1 && children.get(0) instanceof ContentToken) {
            return ((ContentToken)children.get(0)).getContent();
        }
        if (children.size() > 0) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < children.size()) {
                if (children.get(i) instanceof ContentToken) {
                    buf.append(((ContentToken)children.get(i)).getContent());
                } else if (children.get(i) instanceof HTMLTag) {
                    buf.append(((HTMLTag)children.get(i)).getBodyString());
                }
                ++i;
            }
            return buf.toString();
        }
        return "";
    }
}

