/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.buffer;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.impl.store.replication.buffer.LogBufferElement;
import org.apache.derby.impl.store.replication.buffer.LogBufferFullException;

public class ReplicationLogBuffer {
    public static final int DEFAULT_NUMBER_LOG_BUFFERS = 10;
    private final LinkedList dirtyBuffers;
    private final LinkedList freeBuffers;
    private LogBufferElement currentDirtyBuffer;
    private boolean validOutBuffer;
    private byte[] outBufferData;
    private int outBufferStored;
    private long outBufferLastInstant;
    private final Object listLatch = new Object();
    private final Object outputLatch = new Object();
    private int defaultBufferSize;
    private final MasterFactory mf;

    public ReplicationLogBuffer(int n, MasterFactory masterFactory) {
        this.defaultBufferSize = n;
        this.mf = masterFactory;
        this.outBufferData = new byte[n];
        this.outBufferStored = 0;
        this.outBufferLastInstant = 0L;
        this.validOutBuffer = false;
        this.dirtyBuffers = new LinkedList();
        this.freeBuffers = new LinkedList();
        for (int i = 0; i < 10; ++i) {
            LogBufferElement logBufferElement = new LogBufferElement(n);
            this.freeBuffers.addLast(logBufferElement);
        }
        this.currentDirtyBuffer = (LogBufferElement)this.freeBuffers.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLog(long l, byte[] byArray, int n, int n2) throws LogBufferFullException {
        boolean bl = false;
        Object object = this.listLatch;
        synchronized (object) {
            if (this.currentDirtyBuffer == null) {
                this.switchDirtyBuffer();
            }
            if (n2 > this.currentDirtyBuffer.freeSize()) {
                this.switchDirtyBuffer();
                bl = true;
            }
            if (n2 <= this.currentDirtyBuffer.freeSize()) {
                this.currentDirtyBuffer.appendLog(l, byArray, n, n2);
            } else {
                LogBufferElement logBufferElement = new LogBufferElement(n2);
                logBufferElement.setRecyclable(false);
                logBufferElement.appendLog(l, byArray, n, n2);
                this.dirtyBuffers.addLast(logBufferElement);
            }
        }
        if (bl) {
            this.mf.workToDo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        Object object = this.listLatch;
        synchronized (object) {
            if (this.dirtyBuffers.size() == 0) {
                try {
                    this.switchDirtyBuffer();
                }
                catch (LogBufferFullException logBufferFullException) {
                    // empty catch block
                }
            }
            Object object2 = this.outputLatch;
            synchronized (object2) {
                if (this.dirtyBuffers.size() > 0) {
                    LogBufferElement logBufferElement = (LogBufferElement)this.dirtyBuffers.removeFirst();
                    int n = Math.max(this.defaultBufferSize, logBufferElement.size());
                    if (this.outBufferData.length != n) {
                        this.outBufferData = new byte[n];
                    }
                    System.arraycopy(logBufferElement.getData(), 0, this.outBufferData, 0, logBufferElement.size());
                    this.outBufferStored = logBufferElement.size();
                    this.outBufferLastInstant = logBufferElement.getLastInstant();
                    if (logBufferElement.isRecyclable()) {
                        this.freeBuffers.addLast(logBufferElement);
                    }
                    this.validOutBuffer = true;
                } else {
                    this.validOutBuffer = false;
                }
            }
        }
        return this.validOutBuffer;
    }

    public byte[] getData() throws NoSuchElementException {
        Object object = this.outputLatch;
        synchronized (object) {
            byte[] byArray = new byte[this.getSize()];
            if (this.validOutBuffer) {
                System.arraycopy(this.outBufferData, 0, byArray, 0, this.getSize());
                return byArray;
            }
            throw new NoSuchElementException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validData() {
        Object object = this.outputLatch;
        synchronized (object) {
            return this.validOutBuffer;
        }
    }

    public int getSize() throws NoSuchElementException {
        Object object = this.outputLatch;
        synchronized (object) {
            if (this.validOutBuffer) {
                return this.outBufferStored;
            }
            throw new NoSuchElementException();
        }
    }

    public long getLastInstant() throws NoSuchElementException {
        Object object = this.outputLatch;
        synchronized (object) {
            if (this.validOutBuffer) {
                return this.outBufferLastInstant;
            }
            throw new NoSuchElementException();
        }
    }

    private void switchDirtyBuffer() throws LogBufferFullException {
        if (this.currentDirtyBuffer != null && this.currentDirtyBuffer.size() > 0) {
            this.dirtyBuffers.addLast(this.currentDirtyBuffer);
            this.currentDirtyBuffer = null;
        }
        if (this.currentDirtyBuffer == null) {
            try {
                this.currentDirtyBuffer = (LogBufferElement)this.freeBuffers.removeFirst();
                this.currentDirtyBuffer.init();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new LogBufferFullException();
            }
        }
    }

    public int getFillInformation() {
        return this.dirtyBuffers.size() * 100 / 10;
    }
}

