/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.python.antlr.ParseException;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Suite;
import org.python.antlr.base.mod;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Constant;
import org.python.compiler.Future;
import org.python.compiler.PyCodeConstant;
import org.python.compiler.PyComplexConstant;
import org.python.compiler.PyFloatConstant;
import org.python.compiler.PyIntegerConstant;
import org.python.compiler.PyLongConstant;
import org.python.compiler.PyStringConstant;
import org.python.compiler.PyUnicodeConstant;
import org.python.compiler.ScopeInfo;
import org.python.compiler.ScopesCompiler;
import org.python.compiler.SymInfo;
import org.python.core.CodeBootstrap;
import org.python.core.CodeFlag;
import org.python.core.CodeLoader;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyRunnableBootstrap;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;
import org.python.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
implements Opcodes,
ClassConstants,
CompilationContext {
    ClassFile classfile;
    Constant filename;
    String sfilename;
    public Constant mainCode;
    public boolean linenumbers;
    Future futures;
    Hashtable scopes;
    long mtime;
    Hashtable constants;
    List codes;
    private int to_cell;

    public Module(String name, String filename, boolean linenumbers) {
        this(name, filename, linenumbers, -1L);
    }

    public Module(String name, String filename, boolean linenumbers, long mtime) {
        this.linenumbers = linenumbers;
        this.mtime = mtime;
        this.classfile = new ClassFile(name, "org/python/core/PyFunctionTable", 33, mtime);
        this.constants = new Hashtable();
        this.sfilename = filename;
        this.filename = filename != null ? this.PyString(filename) : null;
        this.codes = new ArrayList();
        this.futures = new Future();
        this.scopes = new Hashtable();
    }

    public Module(String name) {
        this(name, name + ".py", true, -1L);
    }

    private Constant findConstant(Constant c) {
        Constant ret = (Constant)this.constants.get(c);
        if (ret != null) {
            return ret;
        }
        ret = c;
        c.module = this;
        c.name = "_" + this.constants.size();
        this.constants.put(ret, ret);
        return ret;
    }

    public Constant PyInteger(int value) {
        return this.findConstant(new PyIntegerConstant(value));
    }

    public Constant PyFloat(double value) {
        return this.findConstant(new PyFloatConstant(value));
    }

    public Constant PyComplex(double value) {
        return this.findConstant(new PyComplexConstant(value));
    }

    public Constant PyString(String value) {
        return this.findConstant(new PyStringConstant(value));
    }

    public Constant PyUnicode(String value) {
        return this.findConstant(new PyUnicodeConstant(value));
    }

    public Constant PyLong(String value) {
        return this.findConstant(new PyLongConstant(value));
    }

    private boolean isJavaIdentifier(String s) {
        char[] chars = s.toCharArray();
        if (chars.length == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return true;
    }

    private List<String> toNameAr(List names, boolean nullok) {
        int sz = names.size();
        if (sz == 0 && nullok) {
            return null;
        }
        ArrayList<String> nameArray = new ArrayList<String>();
        nameArray.addAll(names);
        return nameArray;
    }

    public PyCodeConstant PyCode(mod tree, String name, boolean fast_locals, String className, boolean classBody, boolean printResults, int firstlineno, ScopeInfo scope) throws Exception {
        return this.PyCode(tree, name, fast_locals, className, classBody, printResults, firstlineno, scope, null);
    }

    public PyCodeConstant PyCode(mod tree, String name, boolean fast_locals, String className, boolean classBody, boolean printResults, int firstlineno, ScopeInfo scope, CompilerFlags cflags) throws Exception {
        int nparamcell;
        ArgListCompiler ac;
        PyCodeConstant code = new PyCodeConstant();
        ArgListCompiler argListCompiler = ac = scope != null ? scope.ac : null;
        if (ac != null) {
            code.arglist = ac.arglist;
            code.keywordlist = ac.keywordlist;
            code.argcount = ac.names.size();
        }
        code.co_name = name;
        code.co_firstlineno = firstlineno;
        code.id = this.codes.size();
        code.fname = this.isJavaIdentifier(name) ? name + "$" + code.id : "f$" + code.id;
        this.codes.add(code);
        Code c = this.classfile.addMethod(code.fname, "(Lorg/python/core/PyFrame;Lorg/python/core/ThreadState;)Lorg/python/core/PyObject;", 1);
        CodeCompiler compiler = new CodeCompiler(this, printResults);
        if (classBody) {
            c.aload(1);
            c.ldc("__module__");
            c.aload(1);
            c.ldc("__name__");
            c.invokevirtual("org/python/core/PyFrame", "getname", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
            c.invokevirtual("org/python/core/PyFrame", "setlocal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        }
        Label genswitch = new Label();
        if (scope.generator) {
            c.goto_(genswitch);
        }
        Label start = new Label();
        c.label(start);
        if (ac != null && ac.init_code.size() > 0) {
            ac.appendInitCode((Suite)tree);
        }
        if ((nparamcell = scope.jy_paramcells.size()) > 0) {
            Map<String, SymInfo> tbl = scope.tbl;
            Vector paramcells = scope.jy_paramcells;
            for (int i = 0; i < nparamcell; ++i) {
                c.aload(1);
                SymInfo syminf = tbl.get(paramcells.get(i));
                c.iconst(syminf.locals_index);
                c.iconst(syminf.env_index);
                c.invokevirtual("org/python/core/PyFrame", "to_cell", "(II)V");
            }
        }
        compiler.parse(tree, c, fast_locals, className, classBody, scope, cflags);
        if (scope.generator) {
            c.label(genswitch);
            c.aload(1);
            c.getfield("org/python/core/PyFrame", "f_lasti", "I");
            Label[] yields = new Label[compiler.yields.size() + 1];
            yields[0] = start;
            for (int i = 1; i < yields.length; ++i) {
                yields[i] = (Label)compiler.yields.get(i - 1);
            }
            c.tableswitch(0, yields.length - 1, start, yields);
        }
        if (!classBody) {
            code.names = this.toNameAr(compiler.names, false);
        }
        code.cellvars = this.toNameAr(scope.cellvars, true);
        code.freevars = this.toNameAr(scope.freevars, true);
        code.jy_npurecell = scope.jy_npurecell;
        if (compiler.optimizeGlobals) {
            code.moreflags |= CodeFlag.CO_OPTIMIZED.flag;
        }
        if (compiler.my_scope.generator) {
            code.moreflags |= CodeFlag.CO_GENERATOR.flag;
        }
        if (cflags != null) {
            if (cflags.isFlagSet(CodeFlag.CO_GENERATOR_ALLOWED)) {
                code.moreflags |= CodeFlag.CO_GENERATOR_ALLOWED.flag;
            }
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_DIVISION)) {
                code.moreflags |= CodeFlag.CO_FUTURE_DIVISION.flag;
            }
        }
        code.module = this;
        code.name = code.fname;
        return code;
    }

    public void addInit() throws IOException {
        Code c = this.classfile.addMethod("<init>", "(Ljava/lang/String;)V", 1);
        c.aload(0);
        c.invokespecial("org/python/core/PyFunctionTable", "<init>", "()V");
        this.addConstants(c);
    }

    public void addRunnable() throws IOException {
        Code c = this.classfile.addMethod("getMain", "()Lorg/python/core/PyCode;", 1);
        this.mainCode.get(c);
        c.areturn();
    }

    public void addMain() throws IOException {
        Code c = this.classfile.addMethod("main", "([Ljava/lang/String;)V", 9);
        c.new_(this.classfile.name);
        c.dup();
        c.ldc(this.classfile.name);
        c.invokespecial(this.classfile.name, "<init>", "(Ljava/lang/String;)V");
        c.invokevirtual(this.classfile.name, "getMain", "()Lorg/python/core/PyCode;");
        String bootstrap = Type.getDescriptor(CodeBootstrap.class);
        c.invokestatic(Type.getInternalName(CodeLoader.class), "createSimpleBootstrap", "(Lorg/python/core/PyCode;)" + bootstrap);
        c.aload(0);
        c.invokestatic("org/python/core/Py", "runMain", "(" + bootstrap + "[Ljava/lang/String;" + ")V");
        c.return_();
    }

    public void addBootstrap() throws IOException {
        Code c = this.classfile.addMethod("getCodeBootstrap", "()" + Type.getDescriptor(CodeBootstrap.class), 9);
        c.ldc(Type.getType("L" + this.classfile.name + ";"));
        c.invokestatic(Type.getInternalName(PyRunnableBootstrap.class), "getFilenameConstructorReflectionBootstrap", "(Ljava/lang/Class;)" + Type.getDescriptor(CodeBootstrap.class));
        c.areturn();
    }

    public void addConstants(Code c) throws IOException {
        this.classfile.addField("self", "L" + this.classfile.name + ";", 24);
        c.aload(0);
        c.putstatic(this.classfile.name, "self", "L" + this.classfile.name + ";");
        Enumeration e = this.constants.elements();
        while (e.hasMoreElements()) {
            Constant constant = (Constant)e.nextElement();
            constant.put(c);
        }
        for (int i = 0; i < this.codes.size(); ++i) {
            PyCodeConstant pyc = (PyCodeConstant)this.codes.get(i);
            pyc.put(c);
        }
        c.return_();
    }

    public void addFunctions() throws IOException {
        int i;
        Code code = this.classfile.addMethod("call_function", "(ILorg/python/core/PyFrame;Lorg/python/core/ThreadState;)Lorg/python/core/PyObject;", 1);
        code.aload(0);
        code.aload(2);
        code.aload(3);
        Label def = new Label();
        Label[] labels = new Label[this.codes.size()];
        for (i = 0; i < labels.length; ++i) {
            labels[i] = new Label();
        }
        code.iload(1);
        code.tableswitch(0, labels.length - 1, def, labels);
        for (i = 0; i < labels.length; ++i) {
            code.label(labels[i]);
            code.invokevirtual(this.classfile.name, ((PyCodeConstant)this.codes.get((int)i)).fname, "(Lorg/python/core/PyFrame;Lorg/python/core/ThreadState;)Lorg/python/core/PyObject;");
            code.areturn();
        }
        code.label(def);
        code.aconst_null();
        code.areturn();
    }

    public void write(OutputStream stream) throws IOException {
        this.addInit();
        this.addRunnable();
        this.addMain();
        this.addBootstrap();
        this.addFunctions();
        this.classfile.addInterface("org/python/core/PyRunnable");
        if (this.sfilename != null) {
            this.classfile.setSource(this.sfilename);
        }
        this.classfile.write(stream);
    }

    @Override
    public Future getFutures() {
        return this.futures;
    }

    @Override
    public String getFilename() {
        return this.sfilename;
    }

    @Override
    public ScopeInfo getScopeInfo(PythonTree node) {
        return (ScopeInfo)this.scopes.get(node);
    }

    @Override
    public void error(String msg, boolean err, PythonTree node) throws Exception {
        block3: {
            if (!err) {
                try {
                    Py.warning(Py.SyntaxWarning, msg, this.sfilename != null ? this.sfilename : "?", node.getLine(), null, Py.None);
                    return;
                }
                catch (PyException e) {
                    if (e.match(Py.SyntaxWarning)) break block3;
                    throw e;
                }
            }
        }
        throw new ParseException(msg, node);
    }

    public static void compile(mod node, OutputStream ostream, String name, String filename, boolean linenumbers, boolean printResults, CompilerFlags cflags) throws Exception {
        Module.compile(node, ostream, name, filename, linenumbers, printResults, cflags, -1L);
    }

    public static void compile(mod node, OutputStream ostream, String name, String filename, boolean linenumbers, boolean printResults, CompilerFlags cflags, long mtime) throws Exception {
        Module module = new Module(name, filename, linenumbers, mtime);
        if (cflags == null) {
            cflags = new CompilerFlags();
        }
        module.futures.preprocessFutures(node, cflags);
        new ScopesCompiler(module, module.scopes).parse(node);
        PyCodeConstant main = module.PyCode(node, "<module>", false, null, false, printResults, 0, module.getScopeInfo(node), cflags);
        module.mainCode = main;
        module.write(ostream);
    }
}

