/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.List;
import java.util.Map;

public class TodoCommentCheck
extends AbstractFormatCheck {
    public TodoCommentCheck() {
        super("TODO:");
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void beginTree(DetailAST aRootAST) {
        FileContents contents = this.getFileContents();
        this.checkCppComments(contents);
        this.checkBadComments(contents);
    }

    private void checkCppComments(FileContents aContents) {
        Map<Integer, TextBlock> comments = aContents.getCppComments();
        for (Map.Entry<Integer, TextBlock> entry : comments.entrySet()) {
            String cmt = entry.getValue().getText()[0];
            if (!this.getRegexp().matcher(cmt).find()) continue;
            this.log((int)entry.getKey(), "todo.match", this.getFormat());
        }
    }

    private void checkBadComments(FileContents aContents) {
        Map<Integer, List<TextBlock>> allComments = aContents.getCComments();
        for (Map.Entry<Integer, List<TextBlock>> entry : allComments.entrySet()) {
            for (TextBlock line : entry.getValue()) {
                String[] cmt = line.getText();
                for (int i = 0; i < cmt.length; ++i) {
                    if (!this.getRegexp().matcher(cmt[i]).find()) continue;
                    this.log(entry.getKey() + i, "todo.match", this.getFormat());
                }
            }
        }
    }
}

